/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.cache.limbo;

import com.google.common.base.Preconditions;
import fr.xephi.authme.cache.backup.PlayerDataStorage;
import fr.xephi.authme.cache.limbo.PlayerData;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.SpawnLoader;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class LimboCache {
    private final Map<String, PlayerData> cache = new ConcurrentHashMap<String, PlayerData>();
    private PlayerDataStorage playerDataStorage;
    private Settings settings;
    private PermissionsManager permissionsManager;
    private SpawnLoader spawnLoader;

    @Inject
    LimboCache(Settings settings, PermissionsManager permissionsManager, SpawnLoader spawnLoader, PlayerDataStorage playerDataStorage) {
        this.settings = settings;
        this.permissionsManager = permissionsManager;
        this.spawnLoader = spawnLoader;
        this.playerDataStorage = playerDataStorage;
    }

    public void addPlayerData(Player player) {
        String name = player.getName().toLowerCase();
        Location location = this.spawnLoader.getPlayerLocationOrSpawn(player);
        boolean operator = player.isOp();
        boolean flyEnabled = player.getAllowFlight();
        float walkSpeed = player.getWalkSpeed();
        float flySpeed = player.getFlySpeed();
        String playerGroup = "";
        if (this.permissionsManager.hasGroupSupport()) {
            playerGroup = this.permissionsManager.getPrimaryGroup(player);
        }
        if (this.playerDataStorage.hasData(player)) {
            PlayerData cache = this.playerDataStorage.readData(player);
            if (cache != null) {
                location = cache.getLocation();
                playerGroup = cache.getGroup();
                operator = cache.isOperator();
                flyEnabled = cache.isCanFly();
                walkSpeed = cache.getWalkSpeed();
                flySpeed = cache.getFlySpeed();
            }
        } else {
            this.playerDataStorage.saveData(player);
        }
        this.cache.put(name, new PlayerData(location, operator, playerGroup, flyEnabled, walkSpeed, flySpeed));
    }

    public void restoreData(Player player) {
        String lowerName = player.getName().toLowerCase();
        if (this.cache.containsKey(lowerName)) {
            PlayerData data = this.cache.get(lowerName);
            player.setOp(data.isOperator());
            player.setAllowFlight(data.isCanFly());
            float walkSpeed = data.getWalkSpeed();
            float flySpeed = data.getFlySpeed();
            if (walkSpeed == 0.0f) {
                walkSpeed = 0.2f;
            }
            if (flySpeed == 0.0f) {
                flySpeed = 0.2f;
            }
            player.setWalkSpeed(walkSpeed);
            player.setFlySpeed(flySpeed);
            this.restoreGroup(player, data.getGroup());
            data.clearTasks();
        }
    }

    public void deletePlayerData(Player player) {
        this.removeFromCache(player);
        this.playerDataStorage.removeData(player);
    }

    public void removeFromCache(Player player) {
        String name = player.getName().toLowerCase();
        PlayerData cachedPlayer = this.cache.remove(name);
        if (cachedPlayer != null) {
            cachedPlayer.clearTasks();
        }
    }

    public PlayerData getPlayerData(String name) {
        Preconditions.checkNotNull((Object)name);
        return this.cache.get(name.toLowerCase());
    }

    public boolean hasPlayerData(String name) {
        Preconditions.checkNotNull((Object)name);
        return this.cache.containsKey(name.toLowerCase());
    }

    public void updatePlayerData(Player player) {
        Preconditions.checkNotNull((Object)player);
        this.removeFromCache(player);
        this.addPlayerData(player);
    }

    private void restoreGroup(Player player, String group) {
        if (!StringUtils.isEmpty(group) && this.permissionsManager.hasGroupSupport() && this.settings.getProperty(PluginSettings.ENABLE_PERMISSION_CHECK).booleanValue()) {
            this.permissionsManager.setGroup(player, group);
        }
    }
}

