/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.cache.backup;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.limbo.PlayerData;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.settings.SpawnLoader;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.FileUtils;
import fr.xephi.authme.util.Utils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PlayerDataStorage {
    private final Gson gson;
    private final File cacheDir;
    private PermissionsManager permissionsManager;
    private SpawnLoader spawnLoader;
    private BukkitService bukkitService;

    @Inject
    PlayerDataStorage(@DataFolder File dataFolder, PermissionsManager permsMan, SpawnLoader spawnLoader, BukkitService bukkitService) {
        this.permissionsManager = permsMan;
        this.spawnLoader = spawnLoader;
        this.bukkitService = bukkitService;
        this.cacheDir = new File(dataFolder, "playerdata");
        if (!(this.cacheDir.exists() || this.cacheDir.isDirectory() || this.cacheDir.mkdir())) {
            ConsoleLogger.warning("Failed to create userdata directory.");
        }
        this.gson = new GsonBuilder().registerTypeAdapter(PlayerData.class, (Object)new PlayerDataSerializer()).registerTypeAdapter(PlayerData.class, (Object)new PlayerDataDeserializer()).setPrettyPrinting().create();
    }

    public PlayerData readData(Player player) {
        String id = Utils.getUUIDorName((OfflinePlayer)player);
        File file = new File(this.cacheDir, id + File.separator + "data.json");
        if (!file.exists()) {
            return null;
        }
        try {
            String str = Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
            return (PlayerData)this.gson.fromJson(str, PlayerData.class);
        }
        catch (IOException e) {
            ConsoleLogger.logException("Could not read player data on disk for '" + player.getName() + "'", e);
            return null;
        }
    }

    public void saveData(Player player) {
        String id = Utils.getUUIDorName((OfflinePlayer)player);
        Location location = this.spawnLoader.getPlayerLocationOrSpawn(player);
        String group = "";
        if (this.permissionsManager.hasGroupSupport()) {
            group = this.permissionsManager.getPrimaryGroup(player);
        }
        boolean operator = player.isOp();
        boolean canFly = player.getAllowFlight();
        float walkSpeed = player.getWalkSpeed();
        float flySpeed = player.getFlySpeed();
        PlayerData playerData = new PlayerData(location, operator, group, canFly, walkSpeed, flySpeed);
        try {
            File file = new File(this.cacheDir, id + File.separator + "data.json");
            Files.createParentDirs((File)file);
            Files.touch((File)file);
            Files.write((CharSequence)this.gson.toJson((Object)playerData), (File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            ConsoleLogger.logException("Failed to write " + player.getName() + " data.", e);
        }
    }

    public void removeData(Player player) {
        String id = Utils.getUUIDorName((OfflinePlayer)player);
        File file = new File(this.cacheDir, id);
        if (file.exists()) {
            FileUtils.purgeDirectory(file);
            if (!file.delete()) {
                ConsoleLogger.warning("Failed to remove " + player.getName() + " cache.");
            }
        }
    }

    public boolean hasData(Player player) {
        String id = Utils.getUUIDorName((OfflinePlayer)player);
        File file = new File(this.cacheDir, id + File.separator + "data.json");
        return file.exists();
    }

    private class PlayerDataSerializer
    implements JsonSerializer<PlayerData> {
        private PlayerDataSerializer() {
        }

        public JsonElement serialize(PlayerData playerData, Type type, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("group", playerData.getGroup());
            Location loc = playerData.getLocation();
            JsonObject obj2 = new JsonObject();
            obj2.addProperty("world", loc.getWorld().getName());
            obj2.addProperty("x", (Number)loc.getX());
            obj2.addProperty("y", (Number)loc.getY());
            obj2.addProperty("z", (Number)loc.getZ());
            obj2.addProperty("yaw", (Number)Float.valueOf(loc.getYaw()));
            obj2.addProperty("pitch", (Number)Float.valueOf(loc.getPitch()));
            obj.add("location", (JsonElement)obj2);
            obj.addProperty("operator", Boolean.valueOf(playerData.isOperator()));
            obj.addProperty("can-fly", Boolean.valueOf(playerData.isCanFly()));
            obj.addProperty("walk-speed", (Number)Float.valueOf(playerData.getWalkSpeed()));
            obj.addProperty("fly-speed", (Number)Float.valueOf(playerData.getFlySpeed()));
            return obj;
        }
    }

    private class PlayerDataDeserializer
    implements JsonDeserializer<PlayerData> {
        private PlayerDataDeserializer() {
        }

        public PlayerData deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject == null) {
                return null;
            }
            Location loc = null;
            String group = "";
            boolean operator = false;
            boolean canFly = false;
            float walkSpeed = 0.2f;
            float flySpeed = 0.2f;
            JsonObject e = jsonObject.getAsJsonObject("location");
            if (e != null) {
                JsonObject obj = e.getAsJsonObject();
                World world = PlayerDataStorage.this.bukkitService.getWorld(obj.get("world").getAsString());
                if (world != null) {
                    double x = obj.get("x").getAsDouble();
                    double y = obj.get("y").getAsDouble();
                    double z = obj.get("z").getAsDouble();
                    float yaw = obj.get("yaw").getAsFloat();
                    float pitch = obj.get("pitch").getAsFloat();
                    loc = new Location(world, x, y, z, yaw, pitch);
                }
            }
            if ((e = jsonObject.get("group")) != null) {
                group = e.getAsString();
            }
            if ((e = jsonObject.get("operator")) != null) {
                operator = e.getAsBoolean();
            }
            if ((e = jsonObject.get("can-fly")) != null) {
                canFly = e.getAsBoolean();
            }
            if ((e = jsonObject.get("walk-speed")) != null) {
                walkSpeed = e.getAsFloat();
            }
            if ((e = jsonObject.get("fly-speed")) != null) {
                flySpeed = e.getAsFloat();
            }
            return new PlayerData(loc, operator, group, canFly, walkSpeed, flySpeed);
        }
    }
}

