/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.cache.auth;

import fr.xephi.authme.cache.auth.PlayerAuth;
import java.util.concurrent.ConcurrentHashMap;

public class PlayerCache {
    private static volatile PlayerCache singleton;
    private final ConcurrentHashMap<String, PlayerAuth> cache = new ConcurrentHashMap();

    private PlayerCache() {
    }

    public static PlayerCache getInstance() {
        if (singleton == null) {
            singleton = new PlayerCache();
        }
        return singleton;
    }

    public void addPlayer(PlayerAuth auth) {
        this.cache.put(auth.getNickname().toLowerCase(), auth);
    }

    public void updatePlayer(PlayerAuth auth) {
        this.cache.put(auth.getNickname(), auth);
    }

    public void removePlayer(String user) {
        this.cache.remove(user.toLowerCase());
    }

    public boolean isAuthenticated(String user) {
        return this.cache.containsKey(user.toLowerCase());
    }

    public PlayerAuth getAuth(String user) {
        return this.cache.get(user.toLowerCase());
    }

    public int getLogged() {
        return this.cache.size();
    }

    public ConcurrentHashMap<String, PlayerAuth> getCache() {
        return this.cache;
    }
}

