/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.cache.auth;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import fr.xephi.authme.security.crypts.HashedPassword;
import org.bukkit.Location;

public class PlayerAuth {
    private String nickname;
    private String realName;
    private HashedPassword password;
    private String email;
    private String ip;
    private int groupId;
    private long lastLogin;
    private double x;
    private double y;
    private double z;
    private String world;

    public PlayerAuth(String serialized) {
        this.deserialize(serialized);
    }

    private PlayerAuth(String nickname, HashedPassword password, int groupId, String ip, long lastLogin, double x, double y, double z, String world, String email, String realName) {
        this.nickname = nickname.toLowerCase();
        this.password = password;
        this.ip = ip;
        this.lastLogin = lastLogin;
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
        this.groupId = groupId;
        this.email = email;
        this.realName = realName;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname.toLowerCase();
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setQuitLocation(Location location) {
        this.x = location.getBlockX();
        this.y = location.getBlockY();
        this.z = location.getBlockZ();
        this.world = location.getWorld().getName();
    }

    public double getQuitLocX() {
        return this.x;
    }

    public void setQuitLocX(double d) {
        this.x = d;
    }

    public double getQuitLocY() {
        return this.y;
    }

    public void setQuitLocY(double d) {
        this.y = d;
    }

    public double getQuitLocZ() {
        return this.z;
    }

    public void setQuitLocZ(double d) {
        this.z = d;
    }

    public String getWorld() {
        return this.world;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public long getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(long lastLogin) {
        this.lastLogin = lastLogin;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public HashedPassword getPassword() {
        return this.password;
    }

    public void setPassword(HashedPassword password) {
        this.password = password;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerAuth)) {
            return false;
        }
        PlayerAuth other = (PlayerAuth)obj;
        return other.getIp().equals(this.ip) && other.getNickname().equals(this.nickname);
    }

    public int hashCode() {
        int hashCode = 7;
        hashCode = 71 * hashCode + (this.nickname != null ? this.nickname.hashCode() : 0);
        hashCode = 71 * hashCode + (this.ip != null ? this.ip.hashCode() : 0);
        return hashCode;
    }

    public String toString() {
        return "Player : " + this.nickname + " | " + this.realName + " ! IP : " + this.ip + " ! LastLogin : " + this.lastLogin + " ! LastPosition : " + this.x + "," + this.y + "," + this.z + "," + this.world + " ! Email : " + this.email + " ! Password : {" + this.password.getHash() + ", " + this.password.getSalt() + "}";
    }

    public String serialize() {
        StringBuffer str = new StringBuffer();
        char d = ';';
        str.append(this.nickname).append(d);
        str.append(this.realName).append(d);
        str.append(this.ip).append(d);
        str.append(this.email).append(d);
        str.append(this.password.getHash()).append(d);
        str.append(this.password.getSalt()).append(d);
        str.append(this.groupId).append(d);
        str.append(this.lastLogin).append(d);
        str.append(this.world).append(d);
        str.append(this.x).append(d);
        str.append(this.y).append(d);
        str.append(this.z);
        return str.toString();
    }

    public void deserialize(String str) {
        String[] args = str.split(";");
        this.nickname = args[0];
        this.realName = args[1];
        this.ip = args[2];
        this.email = args[3];
        this.password = new HashedPassword(args[4], args[5]);
        this.groupId = Integer.parseInt(args[6]);
        this.lastLogin = Long.parseLong(args[7]);
        this.world = args[8];
        this.x = Double.parseDouble(args[9]);
        this.y = Double.parseDouble(args[10]);
        this.z = Double.parseDouble(args[11]);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String realName;
        private HashedPassword password;
        private String ip;
        private String world;
        private String email;
        private int groupId = -1;
        private double x = 0.0;
        private double y = 0.0;
        private double z = 0.0;
        private long lastLogin = System.currentTimeMillis();

        public PlayerAuth build() {
            return new PlayerAuth((String)Preconditions.checkNotNull((Object)this.name), (HashedPassword)Objects.firstNonNull((Object)this.password, (Object)new HashedPassword("")), this.groupId, (String)Objects.firstNonNull((Object)this.ip, (Object)"127.0.0.1"), this.lastLogin, this.x, this.y, this.z, (String)Objects.firstNonNull((Object)this.world, (Object)"world"), (String)Objects.firstNonNull((Object)this.email, (Object)"your@email.com"), (String)Objects.firstNonNull((Object)this.realName, (Object)"Player"));
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder realName(String realName) {
            this.realName = realName;
            return this;
        }

        public Builder password(HashedPassword password) {
            this.password = password;
            return this;
        }

        public Builder password(String hash, String salt) {
            return this.password(new HashedPassword(hash, salt));
        }

        public Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public Builder location(Location location) {
            this.x = location.getX();
            this.y = location.getY();
            this.z = location.getZ();
            this.world = location.getWorld().getName();
            return this;
        }

        public Builder locWorld(String world) {
            this.world = world;
            return this;
        }

        public Builder locX(double x) {
            this.x = x;
            return this;
        }

        public Builder locY(double y) {
            this.y = y;
            return this;
        }

        public Builder locZ(double z) {
            this.z = z;
            return this;
        }

        public Builder lastLogin(long lastLogin) {
            this.lastLogin = lastLogin;
            return this;
        }

        public Builder groupId(int groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }
    }
}

