/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.cache;

import com.google.common.annotations.VisibleForTesting;
import fr.xephi.authme.initialization.HasCleanup;
import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.output.Messages;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.Utils;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class TempbanManager
implements SettingsDependent,
HasCleanup {
    private final Map<String, Map<String, TimedCounter>> ipLoginFailureCounts = new ConcurrentHashMap<String, Map<String, TimedCounter>>();
    private final BukkitService bukkitService;
    private final Messages messages;
    private boolean isEnabled;
    private int threshold;
    private int length;
    private long resetThreshold;

    @Inject
    TempbanManager(BukkitService bukkitService, Messages messages, Settings settings) {
        this.bukkitService = bukkitService;
        this.messages = messages;
        this.reload(settings);
    }

    public void increaseCount(String address, String name) {
        if (this.isEnabled) {
            TimedCounter counter;
            Map<String, TimedCounter> countsByName = this.ipLoginFailureCounts.get(address);
            if (countsByName == null) {
                countsByName = new ConcurrentHashMap<String, TimedCounter>();
                this.ipLoginFailureCounts.put(address, countsByName);
            }
            if ((counter = countsByName.get(name)) == null) {
                countsByName.put(name, new TimedCounter(1));
            } else {
                counter.increment(this.resetThreshold);
            }
        }
    }

    public void resetCount(String address, String name) {
        Map<String, TimedCounter> map;
        if (this.isEnabled && (map = this.ipLoginFailureCounts.get(address)) != null) {
            map.remove(name);
        }
    }

    public boolean shouldTempban(String address) {
        Map<String, TimedCounter> countsByName;
        if (this.isEnabled && (countsByName = this.ipLoginFailureCounts.get(address)) != null) {
            int total = 0;
            for (TimedCounter counter : countsByName.values()) {
                total += counter.getCount(this.resetThreshold);
            }
            return total >= this.threshold;
        }
        return false;
    }

    public void tempbanPlayer(final Player player) {
        if (this.isEnabled) {
            final String ip = Utils.getPlayerIp(player);
            final String reason = this.messages.retrieveSingle(MessageKey.TEMPBAN_MAX_LOGINS, new String[0]);
            final Date expires = new Date();
            long newTime = expires.getTime() + (long)this.length * 60000L;
            expires.setTime(newTime);
            this.bukkitService.scheduleSyncDelayedTask(new Runnable(){

                @Override
                public void run() {
                    TempbanManager.this.bukkitService.banIp(ip, reason, expires, "AuthMe");
                    player.kickPlayer(reason);
                }
            });
            this.ipLoginFailureCounts.remove(ip);
        }
    }

    @Override
    public void reload(Settings settings) {
        this.isEnabled = settings.getProperty(SecuritySettings.TEMPBAN_ON_MAX_LOGINS);
        this.threshold = settings.getProperty(SecuritySettings.MAX_LOGIN_TEMPBAN);
        this.length = settings.getProperty(SecuritySettings.TEMPBAN_LENGTH);
        this.resetThreshold = (long)settings.getProperty(SecuritySettings.TEMPBAN_MINUTES_BEFORE_RESET).intValue() * 60000L;
    }

    @Override
    public void performCleanup() {
        for (Map<String, TimedCounter> countsByIp : this.ipLoginFailureCounts.values()) {
            Iterator<TimedCounter> it = countsByIp.values().iterator();
            while (it.hasNext()) {
                TimedCounter counter = it.next();
                if (counter.getCount(this.resetThreshold) != 0) continue;
                it.remove();
            }
        }
    }

    @VisibleForTesting
    static final class TimedCounter {
        private int counter;
        private long lastIncrementTimestamp = System.currentTimeMillis();

        TimedCounter(int start) {
            this.counter = start;
        }

        int getCount(long threshold) {
            if (System.currentTimeMillis() - this.lastIncrementTimestamp > threshold) {
                return 0;
            }
            return this.counter;
        }

        void increment(long threshold) {
            this.counter = this.getCount(threshold) + 1;
            this.lastIncrementTimestamp = System.currentTimeMillis();
        }
    }
}

