/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.cache;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.initialization.HasCleanup;
import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.PluginSettings;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SessionManager
implements SettingsDependent,
HasCleanup {
    private final Map<String, Long> sessions = new ConcurrentHashMap<String, Long>();
    private boolean enabled;
    private int timeoutInMinutes;

    @Inject
    SessionManager(Settings settings) {
        this.reload(settings);
    }

    public boolean hasSession(String name) {
        Long timeout;
        if (this.enabled && (timeout = this.sessions.get(name.toLowerCase())) != null) {
            return System.currentTimeMillis() <= timeout;
        }
        return false;
    }

    public void addSession(String name) {
        if (this.enabled) {
            long timeout = System.currentTimeMillis() + (long)this.timeoutInMinutes * 60000L;
            this.sessions.put(name.toLowerCase(), timeout);
        }
    }

    public void removeSession(String name) {
        this.sessions.remove(name.toLowerCase());
    }

    @Override
    public void reload(Settings settings) {
        this.timeoutInMinutes = settings.getProperty(PluginSettings.SESSIONS_TIMEOUT);
        boolean oldEnabled = this.enabled;
        boolean bl = this.enabled = this.timeoutInMinutes > 0 && settings.getProperty(PluginSettings.SESSIONS_ENABLED) != false;
        if (oldEnabled && !this.enabled) {
            this.sessions.clear();
            ConsoleLogger.fine("Sessions disabled: cleared all sessions");
        }
    }

    @Override
    public void performCleanup() {
        if (!this.enabled) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<String, Long>> iterator = this.sessions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            if (entry.getValue() >= currentTime) continue;
            iterator.remove();
        }
    }
}

