/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.cache;

import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.security.RandomString;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import java.util.concurrent.ConcurrentHashMap;

public class CaptchaManager
implements SettingsDependent {
    private final ConcurrentHashMap<String, Integer> playerCounts = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> captchaCodes = new ConcurrentHashMap();
    private boolean isEnabled;
    private int threshold;
    private int captchaLength;

    @Inject
    CaptchaManager(Settings settings) {
        this.reload(settings);
    }

    public void increaseCount(String name) {
        if (this.isEnabled) {
            String playerLower = name.toLowerCase();
            Integer currentCount = this.playerCounts.get(playerLower);
            if (currentCount == null) {
                this.playerCounts.put(playerLower, 1);
            } else {
                this.playerCounts.put(playerLower, currentCount + 1);
            }
        }
    }

    public boolean isCaptchaRequired(String name) {
        if (this.isEnabled) {
            Integer count = this.playerCounts.get(name.toLowerCase());
            return count != null && count >= this.threshold;
        }
        return false;
    }

    public String getCaptchaCode(String name) {
        return this.captchaCodes.get(name.toLowerCase());
    }

    public String getCaptchaCodeOrGenerateNew(String name) {
        String code = this.getCaptchaCode(name);
        return code == null ? this.generateCode(name) : code;
    }

    public String generateCode(String name) {
        String code = RandomString.generate(this.captchaLength);
        this.captchaCodes.put(name.toLowerCase(), code);
        return code;
    }

    public boolean checkCode(String name, String code) {
        String savedCode = this.captchaCodes.get(name.toLowerCase());
        if (savedCode == null) {
            return true;
        }
        if (savedCode.equalsIgnoreCase(code)) {
            this.captchaCodes.remove(name.toLowerCase());
            this.playerCounts.remove(name.toLowerCase());
            return true;
        }
        return false;
    }

    public void resetCounts(String name) {
        if (this.isEnabled) {
            this.captchaCodes.remove(name.toLowerCase());
            this.playerCounts.remove(name.toLowerCase());
        }
    }

    @Override
    public void reload(Settings settings) {
        this.isEnabled = settings.getProperty(SecuritySettings.USE_CAPTCHA);
        this.threshold = settings.getProperty(SecuritySettings.MAX_LOGIN_TRIES_BEFORE_CAPTCHA);
        this.captchaLength = settings.getProperty(SecuritySettings.CAPTCHA_LENGTH);
    }
}

