/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.api;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.hooks.PluginHooks;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.process.Management;
import fr.xephi.authme.security.PasswordSecurity;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.util.ValidationService;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class NewAPI {
    public static NewAPI singleton;
    public final AuthMe plugin;
    private final PluginHooks pluginHooks;
    private final DataSource dataSource;
    private final PasswordSecurity passwordSecurity;
    private final Management management;
    private final ValidationService validationService;
    private final PlayerCache playerCache;

    @Inject
    NewAPI(AuthMe plugin, PluginHooks pluginHooks, DataSource dataSource, PasswordSecurity passwordSecurity, Management management, ValidationService validationService, PlayerCache playerCache) {
        this.plugin = plugin;
        this.pluginHooks = pluginHooks;
        this.dataSource = dataSource;
        this.passwordSecurity = passwordSecurity;
        this.management = management;
        this.validationService = validationService;
        this.playerCache = playerCache;
        singleton = this;
    }

    public static NewAPI getInstance() {
        if (singleton != null) {
            return singleton;
        }
        return null;
    }

    public AuthMe getPlugin() {
        return this.plugin;
    }

    public String getPluginVersion() {
        return AuthMe.getPluginVersion();
    }

    public boolean isAuthenticated(Player player) {
        return this.playerCache.isAuthenticated(player.getName());
    }

    public boolean isNPC(Player player) {
        return this.pluginHooks.isNpc(player);
    }

    public boolean isUnrestricted(Player player) {
        return this.validationService.isUnrestricted(player.getName());
    }

    public Location getLastLocation(Player player) {
        PlayerAuth auth = this.playerCache.getAuth(player.getName());
        if (auth != null) {
            return new Location(Bukkit.getWorld((String)auth.getWorld()), auth.getQuitLocX(), auth.getQuitLocY(), auth.getQuitLocZ());
        }
        return null;
    }

    public boolean isRegistered(String playerName) {
        String player = playerName.toLowerCase();
        return this.dataSource.isAuthAvailable(player);
    }

    public boolean checkPassword(String playerName, String passwordToCheck) {
        return this.passwordSecurity.comparePassword(passwordToCheck, playerName);
    }

    public boolean registerPlayer(String playerName, String password) {
        String name = playerName.toLowerCase();
        HashedPassword result = this.passwordSecurity.computeHash(password, name);
        if (this.isRegistered(name)) {
            return false;
        }
        PlayerAuth auth = PlayerAuth.builder().name(name).password(result).realName(playerName).build();
        return this.dataSource.saveAuth(auth);
    }

    public void forceLogin(Player player) {
        this.management.performLogin(player, "dontneed", true);
    }

    public void forceLogout(Player player) {
        this.management.performLogout(player);
    }

    public void forceRegister(Player player, String password, boolean autoLogin) {
        this.management.performRegister(player, password, null, autoLogin);
    }

    public void forceRegister(Player player, String password) {
        this.forceRegister(player, password, true);
    }

    public void forceUnregister(Player player) {
        this.management.performUnregisterByAdmin(null, player.getName(), player);
    }

    public void forceUnregister(String name) {
        this.management.performUnregisterByAdmin(null, name, Bukkit.getPlayer((String)name));
    }

    public List<String> getRegisteredNames() {
        ArrayList<String> registeredNames = new ArrayList<String>();
        this.dataSource.getAllAuths().forEach(auth -> registeredNames.add(auth.getNickname()));
        return registeredNames;
    }

    public List<String> getRegisteredRealNames() {
        ArrayList<String> registeredNames = new ArrayList<String>();
        this.dataSource.getAllAuths().forEach(auth -> registeredNames.add(auth.getRealName()));
        return registeredNames;
    }
}

