/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.api;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.hooks.PluginHooks;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.process.Management;
import fr.xephi.authme.security.PasswordSecurity;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.util.ValidationService;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

@Deprecated
public class API {
    public static final String newline = System.getProperty("line.separator");
    public static AuthMe instance;
    private static DataSource dataSource;
    private static PasswordSecurity passwordSecurity;
    private static Management management;
    private static PluginHooks pluginHooks;
    private static ValidationService validationService;

    @Inject
    API(AuthMe instance, DataSource dataSource, PasswordSecurity passwordSecurity, Management management, PluginHooks pluginHooks, ValidationService validationService) {
        API.instance = instance;
        API.dataSource = dataSource;
        API.passwordSecurity = passwordSecurity;
        API.management = management;
        API.pluginHooks = pluginHooks;
        API.validationService = validationService;
    }

    public static AuthMe hookAuthMe() {
        if (instance != null) {
            return instance;
        }
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("AuthMe");
        if (plugin == null || !(plugin instanceof AuthMe)) {
            return null;
        }
        instance = (AuthMe)plugin;
        return instance;
    }

    public static boolean isAuthenticated(Player player) {
        return PlayerCache.getInstance().isAuthenticated(player.getName());
    }

    public static boolean isUnrestricted(Player player) {
        return validationService.isUnrestricted(player.getName());
    }

    public static Location getLastLocation(Player player) {
        try {
            PlayerAuth auth = PlayerCache.getInstance().getAuth(player.getName().toLowerCase());
            if (auth != null) {
                Location loc = new Location(Bukkit.getWorld((String)auth.getWorld()), auth.getQuitLocX(), auth.getQuitLocY(), auth.getQuitLocZ());
                return loc;
            }
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public static void setPlayerInventory(Player player, ItemStack[] content, ItemStack[] armor) {
        try {
            player.getInventory().setContents(content);
            player.getInventory().setArmorContents(armor);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static boolean isRegistered(String playerName) {
        String player = playerName.toLowerCase();
        return dataSource.isAuthAvailable(player);
    }

    public static boolean checkPassword(String playerName, String passwordToCheck) {
        return API.isRegistered(playerName) && passwordSecurity.comparePassword(passwordToCheck, playerName);
    }

    public static boolean registerPlayer(String playerName, String password) {
        String name = playerName.toLowerCase();
        HashedPassword hashedPassword = passwordSecurity.computeHash(password, name);
        if (API.isRegistered(name)) {
            return false;
        }
        PlayerAuth auth = PlayerAuth.builder().name(name).password(hashedPassword).lastLogin(0L).realName(playerName).build();
        return dataSource.saveAuth(auth);
    }

    public static void forceLogin(Player player) {
        management.performLogin(player, "dontneed", true);
    }

    public AuthMe getPlugin() {
        return instance;
    }

    public boolean isNPC(Player player) {
        return pluginHooks.isNpc(player);
    }
}

