/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.BackupSettings;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import fr.xephi.authme.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PerformBackup {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm");
    private final String dbName;
    private final String dbUserName;
    private final String dbPassword;
    private final String tblname;
    private final String path;
    private final File dataFolder;
    private final Settings settings;

    public PerformBackup(AuthMe instance, Settings settings) {
        this.dataFolder = instance.getDataFolder();
        this.settings = settings;
        this.dbName = settings.getProperty(DatabaseSettings.MYSQL_DATABASE);
        this.dbUserName = settings.getProperty(DatabaseSettings.MYSQL_USERNAME);
        this.dbPassword = settings.getProperty(DatabaseSettings.MYSQL_PASSWORD);
        this.tblname = settings.getProperty(DatabaseSettings.MYSQL_TABLE);
        String dateString = DATE_FORMAT.format(new Date());
        this.path = StringUtils.join(File.separator, instance.getDataFolder().getPath(), "backups", "backup" + dateString);
    }

    public void doBackup(BackupCause cause) {
        if (!this.settings.getProperty(BackupSettings.ENABLED).booleanValue()) {
            if (cause == BackupCause.COMMAND || cause == BackupCause.OTHER) {
                ConsoleLogger.warning("Can't perform a Backup: disabled in configuration. Cause of the Backup: " + cause.name());
            }
            return;
        }
        if (BackupCause.START.equals((Object)cause) && !this.settings.getProperty(BackupSettings.ON_SERVER_START).booleanValue() || BackupCause.STOP.equals((Object)cause) && !this.settings.getProperty(BackupSettings.ON_SERVER_STOP).booleanValue()) {
            return;
        }
        if (this.doBackup()) {
            ConsoleLogger.info("A backup has been performed successfully. Cause of the Backup: " + cause.name());
        } else {
            ConsoleLogger.warning("Error while performing a backup! Cause of the Backup: " + cause.name());
        }
    }

    public boolean doBackup() {
        DataSourceType dataSourceType = this.settings.getProperty(DatabaseSettings.BACKEND);
        switch (dataSourceType) {
            case FILE: {
                return this.fileBackup("auths.db");
            }
            case MYSQL: {
                return this.mySqlBackup();
            }
            case SQLITE: {
                return this.fileBackup(this.dbName + ".db");
            }
        }
        ConsoleLogger.warning("Unknown data source type '" + (Object)((Object)dataSourceType) + "' for backup");
        return false;
    }

    private boolean mySqlBackup() {
        String backupWindowsPath;
        File dirBackup = new File(this.dataFolder + File.separator + "backups");
        if (!dirBackup.exists()) {
            dirBackup.mkdir();
        }
        if (PerformBackup.checkWindows(backupWindowsPath = this.settings.getProperty(BackupSettings.MYSQL_WINDOWS_PATH))) {
            String executeCmd = backupWindowsPath + "\\bin\\mysqldump.exe -u " + this.dbUserName + " -p" + this.dbPassword + " " + this.dbName + " --tables " + this.tblname + " -r " + this.path + ".sql";
            try {
                Process runtimeProcess = Runtime.getRuntime().exec(executeCmd);
                int processComplete = runtimeProcess.waitFor();
                if (processComplete == 0) {
                    ConsoleLogger.info("Backup created successfully.");
                    return true;
                }
                ConsoleLogger.warning("Could not create the backup! (Windows)");
            }
            catch (IOException | InterruptedException e) {
                ConsoleLogger.logException("Error during Windows backup:", e);
            }
        } else {
            String executeCmd = "mysqldump -u " + this.dbUserName + " -p" + this.dbPassword + " " + this.dbName + " --tables " + this.tblname + " -r " + this.path + ".sql";
            try {
                Process runtimeProcess = Runtime.getRuntime().exec(executeCmd);
                int processComplete = runtimeProcess.waitFor();
                if (processComplete == 0) {
                    ConsoleLogger.info("Backup created successfully.");
                    return true;
                }
                ConsoleLogger.warning("Could not create the backup!");
            }
            catch (IOException | InterruptedException e) {
                ConsoleLogger.logException("Error during backup:", e);
            }
        }
        return false;
    }

    private boolean fileBackup(String backend) {
        File dirBackup = new File(this.dataFolder + File.separator + "backups");
        if (!dirBackup.exists()) {
            dirBackup.mkdir();
        }
        try {
            PerformBackup.copy("plugins" + File.separator + "AuthMe" + File.separator + backend, this.path + ".db");
            return true;
        }
        catch (IOException ex) {
            ConsoleLogger.logException("Encountered an error during file backup:", ex);
            return false;
        }
    }

    private static boolean checkWindows(String windowsPath) {
        String isWin = System.getProperty("os.name").toLowerCase();
        if (isWin.contains("win")) {
            if (new File(windowsPath + "\\bin\\mysqldump.exe").exists()) {
                return true;
            }
            ConsoleLogger.warning("Mysql Windows Path is incorrect. Please check it");
            return false;
        }
        return false;
    }

    private static void copy(String src, String dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static enum BackupCause {
        START,
        STOP,
        COMMAND,
        OTHER;

    }
}

