/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme;

import com.google.common.base.Throwables;
import fr.xephi.authme.output.LogLevel;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import fr.xephi.authme.util.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;

public final class ConsoleLogger {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("[MM-dd HH:mm:ss]");
    private static Logger logger;
    private static LogLevel logLevel;
    private static boolean useLogging;
    private static File logFile;
    private static FileWriter fileWriter;

    private ConsoleLogger() {
    }

    public static void setLogger(Logger logger) {
        ConsoleLogger.logger = logger;
    }

    public static void setLogFile(File logFile) {
        ConsoleLogger.logFile = logFile;
    }

    public static void setLoggingOptions(Settings settings) {
        logLevel = settings.getProperty(PluginSettings.LOG_LEVEL);
        useLogging = settings.getProperty(SecuritySettings.USE_LOGGING);
        if (useLogging) {
            if (fileWriter == null) {
                try {
                    fileWriter = new FileWriter(logFile, true);
                }
                catch (IOException e) {
                    ConsoleLogger.logException("Failed to create the log file:", e);
                }
            }
        } else {
            ConsoleLogger.close();
        }
    }

    public static void warning(String message) {
        logger.warning(message);
        ConsoleLogger.writeLog("[WARN] " + message);
    }

    public static void info(String message) {
        logger.info(message);
        ConsoleLogger.writeLog("[INFO] " + message);
    }

    public static void fine(String message) {
        if (logLevel.includes(LogLevel.FINE)) {
            logger.info(message);
            ConsoleLogger.writeLog("[FINE] " + message);
        }
    }

    public static void debug(String message) {
        if (logLevel.includes(LogLevel.DEBUG)) {
            logger.info("Debug: " + message);
            ConsoleLogger.writeLog("[DEBUG] " + message);
        }
    }

    public static void logException(String message, Throwable th) {
        ConsoleLogger.warning(message + " " + StringUtils.formatException(th));
        ConsoleLogger.writeLog(Throwables.getStackTraceAsString((Throwable)th));
    }

    public static void close() {
        if (fileWriter != null) {
            try {
                fileWriter.flush();
                fileWriter.close();
                fileWriter = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLog(String message) {
        if (useLogging) {
            String dateTime;
            DateFormat dateFormat = DATE_FORMAT;
            synchronized (dateFormat) {
                dateTime = DATE_FORMAT.format(new Date());
            }
            try {
                fileWriter.write(dateTime);
                fileWriter.write(": ");
                fileWriter.write(message);
                fileWriter.write(NEW_LINE);
                fileWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        logLevel = LogLevel.INFO;
        useLogging = false;
    }
}

