/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme;

import com.google.common.annotations.VisibleForTesting;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.PerformBackup;
import fr.xephi.authme.api.API;
import fr.xephi.authme.api.NewAPI;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.command.CommandHandler;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.initialization.Initializer;
import fr.xephi.authme.initialization.MetricsManager;
import fr.xephi.authme.initialization.OnShutdownPlayerSaver;
import fr.xephi.authme.initialization.TaskCloser;
import fr.xephi.authme.libs.jalu.injector.Injector;
import fr.xephi.authme.libs.jalu.injector.InjectorBuilder;
import fr.xephi.authme.listener.BlockListener;
import fr.xephi.authme.listener.EntityListener;
import fr.xephi.authme.listener.PlayerListener;
import fr.xephi.authme.listener.PlayerListener16;
import fr.xephi.authme.listener.PlayerListener18;
import fr.xephi.authme.listener.PlayerListener19;
import fr.xephi.authme.listener.ServerListener;
import fr.xephi.authme.output.Messages;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.permission.PermissionsSystemType;
import fr.xephi.authme.security.crypts.SHA256;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import fr.xephi.authme.task.CleanupTask;
import fr.xephi.authme.task.purge.PurgeService;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.GeoLiteAPI;
import fr.xephi.authme.util.MigrationService;
import fr.xephi.authme.util.Utils;
import java.io.File;
import java.util.Date;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;

public class AuthMe
extends JavaPlugin {
    private static final String PLUGIN_NAME = "AuthMeReloaded";
    private static final String LOG_FILENAME = "authme.log";
    private static final int CLEANUP_INTERVAL = 6000;
    private static String pluginVersion = "N/D";
    private static String pluginBuildNumber = "Unknown";
    private CommandHandler commandHandler;
    private PermissionsManager permsMan;
    private Settings settings;
    private Messages messages;
    private DataSource database;
    private BukkitService bukkitService;
    private Injector injector;
    private GeoLiteAPI geoLiteApi;
    private PlayerCache playerCache;

    public AuthMe() {
    }

    @VisibleForTesting
    protected AuthMe(PluginLoader loader, Server server, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, server, description, dataFolder, file);
    }

    public static String getPluginName() {
        return PLUGIN_NAME;
    }

    public static String getPluginVersion() {
        return pluginVersion;
    }

    public static String getPluginBuildNumber() {
        return pluginBuildNumber;
    }

    public static NewAPI getApi() {
        return NewAPI.getInstance();
    }

    public void onEnable() {
        try {
            this.initializeServices();
        }
        catch (Exception e) {
            ConsoleLogger.logException("Aborting initialization of AuthMe:", e);
            this.stopOrUnload();
            return;
        }
        this.showSettingsWarnings();
        if (PermissionsSystemType.PERMISSIONS_BUKKIT.equals((Object)this.permsMan.getPermissionSystem())) {
            ConsoleLogger.warning("Warning! This server uses PermissionsBukkit for permissions. Some permissions features may not be supported!");
        }
        new PerformBackup(this, this.settings).doBackup(PerformBackup.BackupCause.START);
        MetricsManager.sendMetrics(this, this.settings);
        ConsoleLogger.info("Development builds are available on our jenkins, thanks to f14stelt.");
        ConsoleLogger.info("Do you want a good game server? Look at our sponsor GameHosting.it leader in Italy as Game Server Provider!");
        ConsoleLogger.info("AuthMe " + AuthMe.getPluginVersion() + " build n." + AuthMe.getPluginBuildNumber() + " correctly enabled!");
        PurgeService purgeService = this.injector.getSingleton(PurgeService.class);
        purgeService.runAutoPurge();
        CleanupTask cleanupTask = this.injector.getSingleton(CleanupTask.class);
        cleanupTask.runTaskTimerAsynchronously((Plugin)this, 6000L, 6000L);
    }

    private void initializeServices() throws Exception {
        this.loadPluginInfo();
        ConsoleLogger.setLogger(this.getLogger());
        ConsoleLogger.setLogFile(new File(this.getDataFolder(), LOG_FILENAME));
        this.settings = Initializer.createSettings(this);
        this.bukkitService = new BukkitService(this, this.settings);
        Initializer initializer = new Initializer(this, this.bukkitService);
        ConsoleLogger.setLoggingOptions(this.settings);
        initializer.setupConsoleFilter(this.settings, this.getLogger());
        this.database = initializer.setupDatabase(this.settings);
        MigrationService.changePlainTextToSha256(this.settings, this.database, new SHA256());
        this.injector = new InjectorBuilder().addDefaultHandlers("fr.xephi.authme").create();
        this.injector.register(AuthMe.class, this);
        this.injector.register(Server.class, this.getServer());
        this.injector.register(PluginManager.class, this.getServer().getPluginManager());
        this.injector.register(BukkitScheduler.class, this.getServer().getScheduler());
        this.injector.provide(DataFolder.class, this.getDataFolder());
        this.injector.register(Settings.class, this.settings);
        this.injector.register(DataSource.class, this.database);
        this.injector.register(BukkitService.class, this.bukkitService);
        this.instantiateServices(this.injector);
        this.reloadSupportHook();
        this.registerEventListeners(this.injector);
        initializer.scheduleRecallEmailTask(this.settings, this.database, this.messages);
    }

    private void loadPluginInfo() {
        String versionRaw = this.getDescription().getVersion();
        int index = versionRaw.lastIndexOf("-");
        if (index != -1) {
            pluginVersion = versionRaw.substring(0, index);
            pluginBuildNumber = versionRaw.substring(index + 1);
            if (pluginBuildNumber.startsWith("b")) {
                pluginBuildNumber = pluginBuildNumber.substring(1);
            }
        }
    }

    protected void instantiateServices(Injector injector) {
        this.playerCache = PlayerCache.getInstance();
        injector.register(PlayerCache.class, this.playerCache);
        this.messages = injector.getSingleton(Messages.class);
        this.permsMan = injector.getSingleton(PermissionsManager.class);
        this.bukkitService = injector.getSingleton(BukkitService.class);
        this.commandHandler = injector.getSingleton(CommandHandler.class);
        this.geoLiteApi = injector.getSingleton(GeoLiteAPI.class);
        injector.getSingleton(NewAPI.class);
        injector.getSingleton(API.class);
    }

    private void showSettingsWarnings() {
        if (!this.settings.getProperty(RestrictionSettings.FORCE_SINGLE_SESSION).booleanValue()) {
            ConsoleLogger.warning("WARNING!!! By disabling ForceSingleSession, your server protection is inadequate!");
        }
        if (this.settings.getProperty(PluginSettings.SESSIONS_TIMEOUT) == 0 && this.settings.getProperty(PluginSettings.SESSIONS_ENABLED).booleanValue()) {
            ConsoleLogger.warning("WARNING!!! You set session timeout to 0, this may cause security issues!");
        }
    }

    protected void registerEventListeners(Injector injector) {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)injector.getSingleton(PlayerListener.class), (Plugin)this);
        pluginManager.registerEvents((Listener)injector.getSingleton(BlockListener.class), (Plugin)this);
        pluginManager.registerEvents((Listener)injector.getSingleton(EntityListener.class), (Plugin)this);
        pluginManager.registerEvents((Listener)injector.getSingleton(ServerListener.class), (Plugin)this);
        if (Utils.isClassLoaded("org.bukkit.event.player.PlayerEditBookEvent")) {
            pluginManager.registerEvents((Listener)injector.getSingleton(PlayerListener16.class), (Plugin)this);
        }
        if (Utils.isClassLoaded("org.bukkit.event.player.PlayerInteractAtEntityEvent")) {
            pluginManager.registerEvents((Listener)injector.getSingleton(PlayerListener18.class), (Plugin)this);
        }
        if (Utils.isClassLoaded("org.bukkit.event.player.PlayerSwapHandItemsEvent")) {
            pluginManager.registerEvents((Listener)injector.getSingleton(PlayerListener19.class), (Plugin)this);
        }
    }

    public void stopOrUnload() {
        if (this.settings == null || this.settings.getProperty(SecuritySettings.STOP_SERVER_ON_PROBLEM).booleanValue()) {
            ConsoleLogger.warning("THE SERVER IS GOING TO SHUT DOWN AS DEFINED IN THE CONFIGURATION!");
            this.setEnabled(false);
            this.getServer().shutdown();
        } else {
            this.setEnabled(false);
        }
    }

    private void reloadSupportHook() {
        if (this.database != null) {
            int playersOnline = this.bukkitService.getOnlinePlayers().size();
            if (playersOnline == 0) {
                this.database.purgeLogged();
            } else if (this.settings.getProperty(SecuritySettings.USE_RELOAD_COMMAND_SUPPORT).booleanValue()) {
                for (PlayerAuth auth : this.database.getLoggedPlayers()) {
                    if (auth == null) continue;
                    auth.setLastLogin(new Date().getTime());
                    this.database.updateSession(auth);
                    this.playerCache.addPlayer(auth);
                }
            }
        }
    }

    public void onDisable() {
        OnShutdownPlayerSaver onShutdownPlayerSaver;
        OnShutdownPlayerSaver onShutdownPlayerSaver2 = onShutdownPlayerSaver = this.injector == null ? null : this.injector.createIfHasDependencies(OnShutdownPlayerSaver.class);
        if (onShutdownPlayerSaver != null) {
            onShutdownPlayerSaver.saveAllPlayers();
        }
        if (this.settings != null) {
            new PerformBackup(this, this.settings).doBackup(PerformBackup.BackupCause.STOP);
        }
        new Thread((Runnable)new TaskCloser(this, this.database), "AuthMe-DataSource#close").start();
        ConsoleLogger.info("AuthMe " + this.getDescription().getVersion() + " disabled!");
        ConsoleLogger.close();
    }

    public String replaceAllInfo(String message, Player player) {
        String playersOnline = Integer.toString(this.bukkitService.getOnlinePlayers().size());
        String ipAddress = Utils.getPlayerIp(player);
        Server server = this.getServer();
        return message.replace("&", "\u00a7").replace("{PLAYER}", player.getName()).replace("{ONLINE}", playersOnline).replace("{MAXPLAYERS}", Integer.toString(server.getMaxPlayers())).replace("{IP}", ipAddress).replace("{LOGINS}", Integer.toString(this.playerCache.getLogged())).replace("{WORLD}", player.getWorld().getName()).replace("{SERVER}", server.getServerName()).replace("{VERSION}", server.getBukkitVersion()).replace("{COUNTRY}", this.geoLiteApi.getCountryName(ipAddress));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (this.commandHandler == null) {
            this.getLogger().severe("AuthMe command handler is not available");
            return false;
        }
        return this.commandHandler.processCommand(sender, commandLabel, args);
    }
}

