/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme;

import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.output.Messages;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.permission.PlayerStatePermission;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.ProtectionSettings;
import fr.xephi.authme.util.BukkitService;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AntiBot {
    private final Settings settings;
    private final Messages messages;
    private final PermissionsManager permissionsManager;
    private final BukkitService bukkitService;
    private final CopyOnWriteArrayList<String> antibotKicked = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<String> antibotPlayers = new CopyOnWriteArrayList();
    private AntiBotStatus antiBotStatus = AntiBotStatus.DISABLED;

    @Inject
    AntiBot(Settings settings, Messages messages, PermissionsManager permissionsManager, BukkitService bukkitService) {
        this.settings = settings;
        this.messages = messages;
        this.permissionsManager = permissionsManager;
        this.bukkitService = bukkitService;
        this.setupAntiBotService();
    }

    private void setupAntiBotService() {
        if (this.settings.getProperty(ProtectionSettings.ENABLE_ANTIBOT).booleanValue()) {
            this.bukkitService.scheduleSyncDelayedTask(new Runnable(){

                @Override
                public void run() {
                    AntiBot.this.antiBotStatus = AntiBotStatus.LISTENING;
                }
            }, 2400L);
        }
    }

    public void overrideAntiBotStatus(boolean activated) {
        if (this.antiBotStatus != AntiBotStatus.DISABLED) {
            this.antiBotStatus = activated ? AntiBotStatus.ACTIVE : AntiBotStatus.LISTENING;
        }
    }

    public AntiBotStatus getAntiBotStatus() {
        return this.antiBotStatus;
    }

    public void activateAntiBot() {
        this.antiBotStatus = AntiBotStatus.ACTIVE;
        for (String s : this.messages.retrieve(MessageKey.ANTIBOT_AUTO_ENABLED_MESSAGE)) {
            this.bukkitService.broadcastMessage(s);
        }
        final int duration = this.settings.getProperty(ProtectionSettings.ANTIBOT_DURATION);
        this.bukkitService.scheduleSyncDelayedTask(new Runnable(){

            @Override
            public void run() {
                if (AntiBot.this.antiBotStatus == AntiBotStatus.ACTIVE) {
                    AntiBot.this.antiBotStatus = AntiBotStatus.LISTENING;
                    AntiBot.this.antibotPlayers.clear();
                    AntiBot.this.antibotKicked.clear();
                    for (String s : AntiBot.this.messages.retrieve(MessageKey.ANTIBOT_AUTO_DISABLED_MESSAGE)) {
                        AntiBot.this.bukkitService.broadcastMessage(s.replace("%m", Integer.toString(duration)));
                    }
                }
            }
        }, duration * 1200);
    }

    public void handlePlayerJoin(final Player player) {
        if (this.antiBotStatus == AntiBotStatus.ACTIVE || this.antiBotStatus == AntiBotStatus.DISABLED) {
            return;
        }
        if (this.permissionsManager.hasPermission((CommandSender)player, PlayerStatePermission.BYPASS_ANTIBOT)) {
            return;
        }
        this.antibotPlayers.add(player.getName().toLowerCase());
        if (this.antibotPlayers.size() > this.settings.getProperty(ProtectionSettings.ANTIBOT_SENSIBILITY)) {
            this.activateAntiBot();
            return;
        }
        this.bukkitService.scheduleSyncDelayedTask(new Runnable(){

            @Override
            public void run() {
                AntiBot.this.antibotPlayers.remove(player.getName().toLowerCase());
            }
        }, 300L);
    }

    public boolean wasPlayerKicked(String name) {
        return this.antibotKicked.contains(name.toLowerCase());
    }

    public void addPlayerKick(String name) {
        this.antibotKicked.addIfAbsent(name.toLowerCase());
    }

    public static enum AntiBotStatus {
        LISTENING,
        DISABLED,
        ACTIVE;

    }
}

