/*
 * Decompiled with CFR 0.152.
 */
package me.danielthumaniel.attributesrevamped.skills;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.danielthumaniel.attributesrevamped.AttributesRevamped;
import me.danielthumaniel.attributesrevamped.Config;
import me.danielthumaniel.attributesrevamped.Stats;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityToggleSwimEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Swim
implements Listener {
    private final AttributesRevamped instance;
    private final Config config;
    Map<UUID, Long> swimmers = new HashMap<UUID, Long>();

    public Swim(AttributesRevamped instance, Config config) {
        this.instance = instance;
        this.config = config;
    }

    @EventHandler
    public void swim(EntityToggleSwimEvent e) {
        if (!this.config.swimEnabled() || !(e.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getEntity();
        boolean swimming = !player.isSwimming();
        Stats stats = Stats.getStats(player);
        if (swimming) {
            this.swimmers.put(player.getUniqueId(), System.currentTimeMillis());
            this.startSwim(player);
        } else {
            if (!this.swimmers.containsKey(player.getUniqueId())) {
                return;
            }
            Double swimTime = (double)(System.currentTimeMillis() - this.swimmers.get(player.getUniqueId())) / 1000.0;
            Double modifierIncrease = (swimTime - swimTime % this.config.getSwimTime()) / this.config.getSwimTime() * this.config.getIncrement("swim", player);
            stats.setSwimSpeed(stats.getSwimSpeed() + modifierIncrease);
            if (stats.getSwimSpeed() > this.config.getMaxLvl()) {
                stats.setSwimSpeed(this.config.getMaxLvl());
            }
        }
    }

    public void startSwim(final Player player) {
        new BukkitRunnable(){

            public void run() {
                if (!player.isSwimming()) {
                    this.cancel();
                }
                Double modifier = 0.16 * Swim.this.config.getStartSwim() * (Swim.this.config.getStartSwim() + (Swim.this.config.getMaxSwim() - Swim.this.config.getStartSwim()) / Swim.this.config.getMaxLvl() * Stats.getStats(player).getSwimSpeed());
                player.setVelocity(player.getEyeLocation().getDirection().clone().multiply(modifier.doubleValue()));
            }
        }.runTaskTimer((Plugin)this.instance, 0L, 1L);
    }
}

