/*
 * Decompiled with CFR 0.152.
 */
package me.danielthumaniel.attributesrevamped.skills;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.danielthumaniel.attributesrevamped.AttributesRevamped;
import me.danielthumaniel.attributesrevamped.Config;
import me.danielthumaniel.attributesrevamped.Stats;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Sprint
implements Listener {
    private final Config config;
    private final AttributesRevamped instance;
    Map<UUID, Long> runners = new HashMap<UUID, Long>();

    public Sprint(AttributesRevamped instance, Config config) {
        this.config = config;
        this.instance = instance;
    }

    @EventHandler
    public void onSprint(PlayerToggleSprintEvent e) {
        if (!this.config.sprintEnabled() || e.getPlayer().getLocation().getBlock().getType() == Material.WATER) {
            return;
        }
        final Player player = e.getPlayer();
        boolean sprinting = !player.isSprinting();
        Stats stats = Stats.getStats(player);
        if (sprinting) {
            this.runners.put(player.getUniqueId(), System.currentTimeMillis());
            player.setWalkSpeed((float)((double)(0.2f * this.config.getStartSpeed().floatValue()) + stats.getSprintSpeed() * ((double)this.config.getMaxSpeed().floatValue() - 1.0) * (0.2 / this.config.getMaxLvl())));
            new BukkitRunnable(){

                public void run() {
                    if (!player.isSprinting()) {
                        player.setWalkSpeed(0.2f);
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)this.instance, 0L, 0L);
        } else {
            if (!this.runners.containsKey(player.getUniqueId())) {
                return;
            }
            Double sprintTime = (double)(System.currentTimeMillis() - this.runners.get(player.getUniqueId())) / 1000.0;
            Double modifierIncrease = (sprintTime - sprintTime % this.config.getSprintTime()) / this.config.getSprintTime() * this.config.getIncrement("sprint", player);
            stats.setSprintSpeed(stats.getSprintSpeed() + modifierIncrease);
            if (stats.getSprintSpeed() > this.config.getMaxLvl()) {
                stats.setSprintSpeed(this.config.getMaxLvl());
            }
        }
    }
}

