/*
 * Decompiled with CFR 0.152.
 */
package me.danielthumaniel.attributesrevamped.skills;

import me.danielthumaniel.attributesrevamped.Config;
import me.danielthumaniel.attributesrevamped.Stats;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;

public class Fall
implements Listener {
    private final Config config;

    public Fall(Config config) {
        this.config = config;
    }

    @EventHandler
    public void onFall(EntityDamageEvent e) {
        if (!(e.getEntity() instanceof Player) || e.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        Player player = (Player)e.getEntity();
        Stats stats = Stats.getStats(player);
        Double damage = e.getDamage() / (this.config.getStartFallDamageReduction() + (this.config.getMaxFallDamageReduction() - this.config.getStartFallDamageReduction()) / this.config.getMaxLvl() * stats.getFallReduction());
        e.setDamage(damage.doubleValue());
        stats.setFallReduction((damage - damage % this.config.getFallDamage()) / this.config.getFallDamage() * this.config.getIncrement("fall", player));
        if (stats.getFallReduction() > this.config.getMaxLvl()) {
            stats.setFallReduction(this.config.getMaxLvl());
        }
    }
}

