/*
 * Decompiled with CFR 0.152.
 */
package me.danielthumaniel.attributesrevamped.skills;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.danielthumaniel.attributesrevamped.Config;
import me.danielthumaniel.attributesrevamped.Stats;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class Endurance
implements Listener {
    private final Config config;
    private static Map<UUID, Double> health = new HashMap<UUID, Double>();

    public Endurance(Config config) {
        this.config = config;
    }

    public static Map<UUID, Double> getHealthMap() {
        return health;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        health.put(player.getUniqueId(), player.getHealth());
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        if (!this.config.enduranceEnabled()) {
            return;
        }
        Player player = e.getPlayer();
        player.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(2.0 * this.config.getStartEndurance() + (2.0 * this.config.getMaxEndurance() - 2.0 * this.config.getStartEndurance()) / this.config.getMaxLvl() * Stats.getStats(player).getEndurance());
        if (health.containsKey(player.getUniqueId())) {
            if (health.get(player.getUniqueId()) <= player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue()) {
                player.setHealth(health.get(player.getUniqueId()).doubleValue());
            }
            health.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        if (!this.config.enduranceEnabled()) {
            return;
        }
        Player player = e.getPlayer();
        player.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(2.0 * this.config.getStartEndurance() + (2.0 * this.config.getMaxEndurance() - 2.0 * this.config.getStartEndurance()) / this.config.getMaxLvl() * Stats.getStats(player).getEndurance());
    }

    @EventHandler
    public void onDamage(EntityDamageEvent e) {
        if (!this.config.enduranceEnabled() || !(e.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getEntity();
        Stats stats = Stats.getStats(player);
        Double damage = e.getDamage() > player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue() ? Double.valueOf(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue()) : Double.valueOf(e.getDamage());
        if (Arrays.asList(EntityDamageEvent.DamageCause.VOID, EntityDamageEvent.DamageCause.CUSTOM).contains(e.getCause())) {
            return;
        }
        Double modifier = (damage - damage % this.config.getEnduranceDamage()) / this.config.getEnduranceDamage() * this.config.getIncrement("endurance", player);
        stats.setEndurance(stats.getEndurance() + modifier);
        if (stats.getEndurance() > this.config.getMaxLvl()) {
            stats.setEndurance(this.config.getMaxLvl());
        }
        player.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(2.0 * this.config.getStartEndurance() + (2.0 * this.config.getMaxEndurance() - 2.0 * this.config.getStartEndurance()) / this.config.getMaxLvl() * stats.getEndurance());
    }
}

