/*
 * Decompiled with CFR 0.152.
 */
package me.danielthumaniel.attributesrevamped.skills;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.danielthumaniel.attributesrevamped.AttributesRevamped;
import me.danielthumaniel.attributesrevamped.Config;
import me.danielthumaniel.attributesrevamped.Stats;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Breath
implements Listener {
    private final AttributesRevamped instance;
    private final Config config;
    Map<UUID, Long> breathers = new HashMap<UUID, Long>();

    public Breath(AttributesRevamped instance, Config config) {
        this.instance = instance;
        this.config = config;
    }

    @EventHandler
    public void onBreath(EntityAirChangeEvent e) {
        if (!(e.getEntity() instanceof Player) || this.breathers.containsKey(((Player)e.getEntity()).getUniqueId())) {
            return;
        }
        final Player player = (Player)e.getEntity();
        final Stats stats = Stats.getStats(player);
        if (player.getRemainingAir() == 300 && player.getEyeLocation().getBlock().getType() == Material.WATER) {
            this.breathers.put(player.getUniqueId(), System.currentTimeMillis());
            new BukkitRunnable(){
                int air;
                int count;
                int modulo;
                {
                    this.air = player2.getRemainingAir();
                    this.count = 0;
                    this.modulo = (int)Math.floor(1.0 + stats2.getBreathTime() / Breath.this.config.getMaxLvl() * (Breath.this.config.getMaxBreathTime() - 1.0));
                }

                public void run() {
                    if (player.getRemainingAir() == 0 || player.getEyeLocation().getBlock().getType() != Material.WATER) {
                        Double breathTime = (double)(System.currentTimeMillis() - Breath.this.breathers.get(player.getUniqueId())) / 1000.0;
                        Double modifierIncrease = (breathTime - breathTime % Breath.this.config.getBreathTime()) / Breath.this.config.getBreathTime() * Breath.this.config.getIncrement("breath", player);
                        stats.setBreathTime(stats.getBreathTime() + modifierIncrease);
                        if (stats.getBreathTime() > Breath.this.config.getMaxLvl()) {
                            stats.setBreathTime(Breath.this.config.getMaxLvl());
                        }
                        Breath.this.breathers.remove(player.getUniqueId());
                        this.cancel();
                    }
                    ++this.count;
                    if (this.count % this.modulo == 0) {
                        --this.air;
                    }
                    player.setRemainingAir(this.air);
                }
            }.runTaskTimer((Plugin)this.instance, 0L, 1L);
        }
    }
}

