/*
 * Decompiled with CFR 0.152.
 */
package me.danielthumaniel.attributesrevamped.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.danielthumaniel.attributesrevamped.Config;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class AttributesTabComplete
implements TabCompleter {
    List<String> argumentsInitial = Arrays.asList("view", "set", "add");
    List<String> argumentsPlayers = new ArrayList<String>();
    List<String> argumentsStats = Arrays.asList("speed", "endurance", "swimspeed", "falldamage", "lungcapacity");
    private final Config config;

    public AttributesTabComplete(Config config) {
        this.config = config;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        if (this.argumentsPlayers.isEmpty()) {
            OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
            int n = offlinePlayerArray.length;
            int n2 = 0;
            while (n2 < n) {
                OfflinePlayer p = offlinePlayerArray[n2];
                this.argumentsPlayers.add(p.getName());
                ++n2;
            }
            for (OfflinePlayer p : Bukkit.getOnlinePlayers()) {
                if (this.argumentsPlayers.contains(p.getName())) continue;
                this.argumentsPlayers.add(p.getName());
            }
        }
        ArrayList<String> resultInitial = new ArrayList<String>();
        ArrayList<String> resultPlayers = new ArrayList<String>();
        ArrayList<String> resultStats = new ArrayList<String>();
        ArrayList<String> resultNumber = new ArrayList<String>();
        if (args.length == 1) {
            for (String initial : this.argumentsInitial) {
                if (!initial.toLowerCase().startsWith(args[0])) continue;
                if (initial.equalsIgnoreCase("view") && player.hasPermission("attributes.view")) {
                    resultInitial.add(initial);
                }
                if (initial.equalsIgnoreCase("set") && player.hasPermission("attributes.set")) {
                    resultInitial.add(initial);
                }
                if (!initial.equalsIgnoreCase("add") || !player.hasPermission("attributes.add")) continue;
                resultInitial.add(initial);
            }
            return resultInitial;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("view") && player.hasPermission("attributes.view") || args[0].equalsIgnoreCase("set") && player.hasPermission("attributes.set") || args[0].equalsIgnoreCase("add") && player.hasPermission("attributes.add")) {
                for (String s : this.argumentsPlayers) {
                    if (!s.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                    resultPlayers.add(s);
                }
            }
            return resultPlayers;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("set")) {
            if (player.hasPermission("attributes.set")) {
                for (String s : this.argumentsStats) {
                    if (!s.toLowerCase().startsWith(args[2])) continue;
                    resultStats.add(s);
                }
            }
            return resultStats;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("add")) {
            if (player.hasPermission("attributes.add")) {
                for (String s : this.argumentsStats) {
                    if (!s.toLowerCase().startsWith(args[2])) continue;
                    resultStats.add(s);
                }
            }
            return resultStats;
        }
        if (args.length == 4 && (args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("add")) && this.argumentsStats.contains(args[2].toLowerCase())) {
            if (player.hasPermission("attributes.set") || player.hasPermission("attributes.add")) {
                resultNumber.add("<" + this.config.getMinLvl() + "-" + this.config.getMaxLvl() + ">");
            }
            return resultNumber;
        }
        return new ArrayList<String>();
    }
}

