/*
 * Decompiled with CFR 0.152.
 */
package me.danielthumaniel.attributesrevamped.commands;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.danielthumaniel.attributesrevamped.Config;
import me.danielthumaniel.attributesrevamped.Stats;
import me.danielthumaniel.attributesrevamped.utils.UUIDFetcher;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AttributesCommand
implements CommandExecutor {
    private final Config config;

    public AttributesCommand(Config config) {
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        block73: {
            Stats stats;
            block74: {
                Player target;
                if (args.length != 0 && args.length != 2 && args.length != 4) {
                    return false;
                }
                if (args.length == 0 && sender instanceof Player && (target = (Player)sender).hasPermission("attributes.list")) {
                    target.sendMessage(this.stats(target.getName()));
                    return true;
                }
                if (args.length == 2) {
                    if (!args[0].equalsIgnoreCase("view")) {
                        return false;
                    }
                    if (sender instanceof Player && !((Player)sender).hasPermission("attributes.view")) {
                        return true;
                    }
                    sender.sendMessage(this.stats(args[1]));
                    return true;
                }
                if (args.length != 4) break block73;
                if (!args[0].equalsIgnoreCase("set")) break block74;
                if (sender instanceof Player && !((Player)sender).hasPermission("attributes.set")) {
                    return true;
                }
                if (!Stats.getIdMap().containsKey(args[1].toLowerCase())) {
                    try {
                        Stats.getIdMap().put(args[1].toLowerCase(), UUIDFetcher.getUUID(args[1]));
                    }
                    catch (IOException e) {
                        sender.sendMessage(ChatColor.RED + "Player not found!");
                    }
                }
                if (!Stats.getStatsMap().containsKey(Stats.getIdMap().get(args[1].toLowerCase()))) {
                    Stats.getStatsMap().put(Stats.getIdMap().get(args[1].toLowerCase()), new Stats(this.config));
                }
                stats = Stats.getStatsMap().get(Stats.getIdMap().get(args[1].toLowerCase()));
                if (!Arrays.asList("speed", "endurance", "swimspeed", "falldamage", "lungcapacity").contains(args[2].toLowerCase())) {
                    return true;
                }
                if (args[2].equalsIgnoreCase("speed") && !this.config.sprintEnabled() || args[2].equalsIgnoreCase("endurance") && !this.config.enduranceEnabled() || args[2].equalsIgnoreCase("swimspeed") && !this.config.swimEnabled() || args[2].equalsIgnoreCase("falldamage") && !this.config.fallEnabled() || args[2].equalsIgnoreCase("lungcapacity") && !this.config.breathEnabled()) {
                    sender.sendMessage(ChatColor.RED + args[2] + " is not Enabled!");
                    return true;
                }
                Double stat = 0.0;
                try {
                    stat = Double.parseDouble(args[3]);
                }
                catch (Exception e) {
                    sender.sendMessage(ChatColor.RED + "\"" + args[3] + "\"" + " is not a number!");
                    return true;
                }
                if (stat > this.config.getMaxLvl() || stat < this.config.getMinLvl()) {
                    sender.sendMessage(ChatColor.RED + "The new stat must be between " + this.config.getMinLvl() + " and " + this.config.getMaxLvl() + "!");
                    return true;
                }
                switch (args[2].toLowerCase()) {
                    case "speed": {
                        stats.setSprintSpeed(stat);
                        Stats.getStatsMap().replace(Stats.getIdMap().get(args[1].toLowerCase()), stats);
                        break;
                    }
                    case "endurance": {
                        stats.setEndurance(stat);
                        Stats.getStatsMap().replace(Stats.getIdMap().get(args[1].toLowerCase()), stats);
                        if (!this.getOnlinePlayerNames().contains(args[1].toLowerCase())) break;
                        Bukkit.getPlayer((String)args[1]).damage(0.0);
                        break;
                    }
                    case "swimspeed": {
                        stats.setSwimSpeed(stat);
                        Stats.getStatsMap().replace(Stats.getIdMap().get(args[1].toLowerCase()), stats);
                        break;
                    }
                    case "falldamage": {
                        stats.setFallReduction(stat);
                        Stats.getStatsMap().replace(Stats.getIdMap().get(args[1].toLowerCase()), stats);
                        break;
                    }
                    case "lungcapacity": {
                        stats.setBreathTime(stat);
                        Stats.getStatsMap().replace(Stats.getIdMap().get(args[1].toLowerCase()), stats);
                        break;
                    }
                    default: {
                        return true;
                    }
                }
                sender.sendMessage(ChatColor.AQUA + args[1] + "'s " + args[2] + " has been set to " + args[3] + "!");
                return true;
            }
            if (!args[0].equalsIgnoreCase("add")) break block73;
            if (sender instanceof Player && !((Player)sender).hasPermission("attributes.add")) {
                return true;
            }
            if (!Stats.getIdMap().containsKey(args[1].toLowerCase())) {
                try {
                    Stats.getIdMap().put(args[1].toLowerCase(), UUIDFetcher.getUUID(args[1]));
                }
                catch (IOException e) {
                    sender.sendMessage(ChatColor.RED + "Player not found!");
                }
            }
            if (!Stats.getStatsMap().containsKey(Stats.getIdMap().get(args[1].toLowerCase()))) {
                Stats.getStatsMap().put(Stats.getIdMap().get(args[1].toLowerCase()), new Stats(this.config));
            }
            stats = Stats.getStatsMap().get(Stats.getIdMap().get(args[1].toLowerCase()));
            if (!Arrays.asList("speed", "endurance", "swimspeed", "falldamage", "lungcapacity").contains(args[2].toLowerCase())) {
                return true;
            }
            if (args[2].equalsIgnoreCase("speed") && !this.config.sprintEnabled() || args[2].equalsIgnoreCase("endurance") && !this.config.enduranceEnabled() || args[2].equalsIgnoreCase("swimspeed") && !this.config.swimEnabled() || args[2].equalsIgnoreCase("falldamage") && !this.config.fallEnabled() || args[2].equalsIgnoreCase("lungcapacity") && !this.config.breathEnabled()) {
                sender.sendMessage(ChatColor.RED + args[2] + " is not Enabled!");
                return true;
            }
            Double stat = 0.0;
            try {
                stat = Double.parseDouble(args[3]);
            }
            catch (Exception e) {
                sender.sendMessage(ChatColor.RED + "\"" + args[3] + "\"" + " is not a number!");
                return true;
            }
            if (stat > this.config.getMaxLvl() || stat < this.config.getMinLvl()) {
                sender.sendMessage(ChatColor.RED + "The new addition must be between " + this.config.getMinLvl() + " and " + this.config.getMaxLvl() + "!");
                return true;
            }
            switch (args[2].toLowerCase()) {
                case "speed": {
                    if (stats.getSprintSpeed() + stat > this.config.getMaxLvl()) {
                        stats.setSprintSpeed(this.config.getMaxLvl());
                    } else {
                        stats.setSprintSpeed(stats.getSprintSpeed() + stat);
                    }
                    Stats.getStatsMap().replace(Stats.getIdMap().get(args[1].toLowerCase()), stats);
                    break;
                }
                case "endurance": {
                    if (stats.getEndurance() + stat > this.config.getMaxLvl()) {
                        stats.setEndurance(this.config.getMaxLvl());
                    } else {
                        stats.setEndurance(stats.getEndurance() + stat);
                    }
                    Stats.getStatsMap().replace(Stats.getIdMap().get(args[1].toLowerCase()), stats);
                    if (!this.getOnlinePlayerNames().contains(args[1].toLowerCase())) break;
                    Bukkit.getPlayer((String)args[1]).damage(0.0);
                    break;
                }
                case "swimspeed": {
                    if (stats.getSwimSpeed() + stat > this.config.getMaxLvl()) {
                        stats.setSwimSpeed(this.config.getMaxLvl());
                    } else {
                        stats.setSwimSpeed(stats.getSwimSpeed() + stat);
                    }
                    Stats.getStatsMap().replace(Stats.getIdMap().get(args[1].toLowerCase()), stats);
                    break;
                }
                case "falldamage": {
                    if (stats.getFallReduction() + stat > this.config.getMaxLvl()) {
                        stats.setFallReduction(this.config.getMaxLvl());
                    } else {
                        stats.setFallReduction(stats.getFallReduction() + stat);
                    }
                    Stats.getStatsMap().replace(Stats.getIdMap().get(args[1].toLowerCase()), stats);
                    break;
                }
                case "lungcapacity": {
                    if (stats.getBreathTime() + stat > this.config.getMaxLvl()) {
                        stats.setBreathTime(this.config.getMaxLvl());
                    } else {
                        stats.setBreathTime(stats.getBreathTime() + stat);
                    }
                    Stats.getStatsMap().replace(Stats.getIdMap().get(args[1].toLowerCase()), stats);
                    break;
                }
                default: {
                    return true;
                }
            }
            sender.sendMessage(ChatColor.AQUA + args[1] + "'s " + args[2] + " has increased by " + args[3] + "!");
            return true;
        }
        return false;
    }

    private String stats(String name) {
        if (!Stats.getIdMap().containsKey(name.toLowerCase())) {
            try {
                Stats.getIdMap().put(name.toLowerCase(), UUIDFetcher.getUUID(name));
            }
            catch (IOException e) {
                return ChatColor.RED + "Player not found!";
            }
        }
        if (!Stats.getStatsMap().containsKey(Stats.getIdMap().get(name.toLowerCase()))) {
            Stats.getStatsMap().put(Stats.getIdMap().get(name.toLowerCase()), new Stats(this.config));
        }
        Stats stats = Stats.getStatsMap().get(Stats.getIdMap().get(name.toLowerCase()));
        Double running = stats.getSprintSpeed();
        Double endurance = stats.getEndurance();
        Double swimming = stats.getSwimSpeed();
        Double falling = stats.getFallReduction();
        Double breathing = stats.getBreathTime();
        DecimalFormat df = new DecimalFormat("###.##");
        String sprint = "";
        String endure = "";
        String swim = "";
        String fall = "";
        String breath = "";
        sprint = this.config.sprintEnabled() ? String.valueOf(df.format(running)) : "Disabled";
        endure = this.config.enduranceEnabled() ? String.valueOf(df.format(endurance)) : "Disabled";
        swim = this.config.swimEnabled() ? String.valueOf(df.format(swimming)) : "Disabled";
        fall = this.config.fallEnabled() ? String.valueOf(df.format(falling)) : "Disabled";
        breath = this.config.breathEnabled() ? String.valueOf(df.format(breathing)) : "Disabled";
        String newLine = System.getProperty("line.separator");
        String returnString = String.join((CharSequence)newLine, ChatColor.translateAlternateColorCodes((char)'&', (String)"&2&m                                    "), ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&lAttributes"), ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Player:&r&f " + name)), ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Speed:&r&f " + sprint)), ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Endurance:&r&f " + endure)), ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Swim-Speed:&r&f " + swim)), ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Fall-Damage:&r&f " + fall)), ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Lung-Capacity:&r&f " + breath)), ChatColor.translateAlternateColorCodes((char)'&', (String)"&2&m                                    "));
        if (this.config.sprintEnabled() || this.config.enduranceEnabled() || this.config.swimEnabled() || this.config.fallEnabled() || this.config.breathEnabled()) {
            return returnString;
        }
        return ChatColor.RED + "No Attributes are enabled!";
    }

    private List<String> getOnlinePlayerNames() {
        ArrayList<String> online = new ArrayList<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            online.add(player.getName().toLowerCase());
        }
        return online;
    }
}

