/*
 * Decompiled with CFR 0.152.
 */
package me.danielthumaniel.attributesrevamped;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.danielthumaniel.attributesrevamped.Config;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class Stats
implements Listener {
    private final Config config;
    private Double sprintSpeed;
    private Double endurance;
    private Double swimSpeed;
    private Double fallDamage;
    private Double breathTime;
    private static Map<UUID, Stats> playerStats = new HashMap<UUID, Stats>();
    private static Map<String, UUID> playerIds = new HashMap<String, UUID>();

    public Stats(Config config, Double sprintSpeed, Double endurance, Double swimSpeed, Double fallDamage, Double breathTime) {
        this.config = config;
        this.sprintSpeed = sprintSpeed;
        this.endurance = endurance;
        this.swimSpeed = swimSpeed;
        this.fallDamage = fallDamage;
        this.breathTime = breathTime;
    }

    public Stats(Config config) {
        this.config = config;
        this.sprintSpeed = config.getMinLvl();
        this.endurance = config.getMinLvl();
        this.swimSpeed = config.getMinLvl();
        this.fallDamage = config.getMinLvl();
        this.breathTime = config.getMinLvl();
    }

    public Double getSprintSpeed() {
        return this.sprintSpeed;
    }

    public Double getEndurance() {
        return this.endurance;
    }

    public Double getSwimSpeed() {
        return this.swimSpeed;
    }

    public Double getFallReduction() {
        return this.fallDamage;
    }

    public Double getBreathTime() {
        return this.breathTime;
    }

    public void setSprintSpeed(Double sprintSpeed) {
        this.sprintSpeed = sprintSpeed;
    }

    public void setEndurance(Double endurance) {
        this.endurance = endurance;
    }

    public void setSwimSpeed(Double swimSpeed) {
        this.swimSpeed = swimSpeed;
    }

    public void setFallReduction(Double fallDamage) {
        this.fallDamage = fallDamage;
    }

    public void setBreathTime(Double breathTime) {
        this.breathTime = breathTime;
    }

    public static Stats getStats(Player player) {
        return playerStats.get(player.getUniqueId());
    }

    public static Map<UUID, Stats> getStatsMap() {
        return playerStats;
    }

    public static Map<String, UUID> getIdMap() {
        return playerIds;
    }

    public String serialize() {
        return String.join((CharSequence)";", this.sprintSpeed.toString().replace(".", "dot"), this.endurance.toString().replace(".", "dot"), this.swimSpeed.toString().replace(".", "dot"), this.fallDamage.toString().replace(".", "dot"), this.breathTime.toString().replace(".", "dot"));
    }

    public static Stats deserialize(String string, Config config) {
        String[] stats = string.split(";");
        return new Stats(config, Double.parseDouble(stats[0].replace("dot", ".")), Double.parseDouble(stats[1].replace("dot", ".")), Double.parseDouble(stats[2].replace("dot", ".")), Double.parseDouble(stats[3].replace("dot", ".")), Double.parseDouble(stats[4].replace("dot", ".")));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent e) {
        if (!playerStats.containsKey(e.getPlayer().getUniqueId())) {
            playerStats.put(e.getPlayer().getUniqueId(), new Stats(this.config));
        }
        if (!playerIds.containsKey(e.getPlayer().getName().toLowerCase())) {
            playerIds.put(e.getPlayer().getName().toLowerCase(), e.getPlayer().getUniqueId());
        }
    }
}

