/*
 * Decompiled with CFR 0.152.
 */
package me.danielthumaniel.attributesrevamped;

import me.danielthumaniel.attributesrevamped.Stats;
import me.danielthumaniel.attributesrevamped.utils.DataManager;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class Config {
    private final Double minLvl;
    private final Double maxLvl;
    private final Double defaultIncrement;
    private final Double variableIncrement;
    private final Double sprintTime;
    private final Double swimTime;
    private final Double enduranceDamage;
    private final Double fallDamage;
    private final Double breathTime;
    private final Float startSpeed;
    private final Double startSwim;
    private final Double startEndurance;
    private final Double startFall;
    private final Float maxSpeed;
    private final Double maxSwim;
    private final Double maxEndurance;
    private final Double maxFall;
    private final Double maxBreath;
    private final Double customSpeedIncrement;
    private final Double customSwimIncrement;
    private final Double customEnduranceIncrement;
    private final Double customFallIncrement;
    private final Double customBreathIncrement;
    private final boolean sprint;
    private final boolean swim;
    private final boolean endurance;
    private final boolean fall;
    private final boolean breath;
    private final boolean updateChecker;

    public Config(DataManager data) {
        FileConfiguration config = data.getConfig();
        this.minLvl = config.getDouble("Starting Level");
        this.maxLvl = config.getDouble("Maximum Level");
        this.defaultIncrement = config.getDouble("Default Increment");
        this.variableIncrement = config.getDouble("Variable Increment");
        this.sprintTime = config.getDouble("Sprint Time");
        this.swimTime = config.getDouble("Swim Time");
        this.enduranceDamage = config.getDouble("Endurance Damage");
        this.fallDamage = config.getDouble("Fall Damage");
        this.breathTime = config.getDouble("Breath Time");
        this.startSpeed = Float.valueOf((float)config.getDouble("Starting Sprint Speed"));
        this.startSwim = config.getDouble("Starting Swim Speed");
        this.startEndurance = config.getDouble("Starting Endurance");
        this.startFall = config.getDouble("Starting Fall Damage Reduction");
        this.maxSpeed = Float.valueOf((float)config.getDouble("Maximum Sprint Speed"));
        this.maxSwim = config.getDouble("Maximum Swim Speed");
        this.maxEndurance = config.getDouble("Maximum Endurance");
        this.maxFall = config.getDouble("Maximum Fall Damage Reduction");
        this.maxBreath = config.getDouble("Maximum Lung Capacity");
        this.customSpeedIncrement = config.getDouble("Custom Sprint Increment");
        this.customSwimIncrement = config.getDouble("Custom Swim Increment");
        this.customEnduranceIncrement = config.getDouble("Custom Endurance Increment");
        this.customFallIncrement = config.getDouble("Custom Fall Increment");
        this.customBreathIncrement = config.getDouble("Custom Breath Increment");
        this.sprint = config.getString("Sprint Attribute").equalsIgnoreCase("Enabled");
        this.swim = config.getString("Swim Attribute").equalsIgnoreCase("Enabled");
        this.endurance = config.getString("Endurance Attribute").equalsIgnoreCase("Enabled");
        this.fall = config.getString("Fall Damage Attribute").equalsIgnoreCase("Enabled");
        this.breath = config.getString("Lung Capacity Attribute").equalsIgnoreCase("Enabled");
        this.updateChecker = config.getString("Update Checker").equalsIgnoreCase("Enabled");
    }

    public Double getMinLvl() {
        return this.minLvl;
    }

    public Double getMaxLvl() {
        return this.maxLvl;
    }

    public Double getDefaultIncrement() {
        return this.defaultIncrement;
    }

    public Double getVariableIncrement() {
        return this.variableIncrement;
    }

    public Double getSprintTime() {
        return this.sprintTime;
    }

    public Double getSwimTime() {
        return this.swimTime;
    }

    public Double getEnduranceDamage() {
        return this.enduranceDamage;
    }

    public Double getFallDamage() {
        return this.fallDamage;
    }

    public Double getBreathTime() {
        return this.breathTime;
    }

    public Float getStartSpeed() {
        return this.startSpeed;
    }

    public Double getStartSwim() {
        return this.startSwim;
    }

    public Double getStartEndurance() {
        return this.startEndurance;
    }

    public Double getStartFallDamageReduction() {
        return this.startFall;
    }

    public Float getMaxSpeed() {
        return this.maxSpeed;
    }

    public Double getMaxSwim() {
        return this.maxSwim;
    }

    public Double getMaxEndurance() {
        return this.maxEndurance;
    }

    public Double getMaxFallDamageReduction() {
        return this.maxFall;
    }

    public Double getMaxBreathTime() {
        return this.maxBreath;
    }

    public Double getCustomSpeedIncrement() {
        return this.customSpeedIncrement;
    }

    public Double getCustomSwimIncrement() {
        return this.customSwimIncrement;
    }

    public Double getCustomEnduranceIncrement() {
        return this.customEnduranceIncrement;
    }

    public Double getCustomFallIncrement() {
        return this.customFallIncrement;
    }

    public Double getCustomBreathIncrement() {
        return this.customBreathIncrement;
    }

    public boolean sprintEnabled() {
        return this.sprint;
    }

    public boolean swimEnabled() {
        return this.swim;
    }

    public boolean enduranceEnabled() {
        return this.endurance;
    }

    public boolean fallEnabled() {
        return this.fall;
    }

    public boolean breathEnabled() {
        return this.breath;
    }

    public boolean updateCheckerEnabled() {
        return this.updateChecker;
    }

    public Double getIncrement(String type, Player player) {
        switch (type.toLowerCase()) {
            case "sprint": {
                if (!this.variableIncrement.equals(0.0)) {
                    return this.defaultIncrement * Math.pow(this.variableIncrement / this.defaultIncrement, Stats.getStats(player).getSprintSpeed() / this.maxLvl);
                }
                if (this.customSpeedIncrement.equals(0.0)) break;
                return this.customSpeedIncrement;
            }
            case "swim": {
                if (!this.variableIncrement.equals(0.0)) {
                    return this.defaultIncrement * Math.pow(this.variableIncrement / this.defaultIncrement, Stats.getStats(player).getSwimSpeed() / this.maxLvl);
                }
                if (this.customSwimIncrement.equals(0.0)) break;
                return this.customSwimIncrement;
            }
            case "endurance": {
                if (!this.variableIncrement.equals(0.0)) {
                    return this.defaultIncrement * Math.pow(this.variableIncrement / this.defaultIncrement, Stats.getStats(player).getEndurance() / this.maxLvl);
                }
                if (this.customEnduranceIncrement.equals(0.0)) break;
                return this.customEnduranceIncrement;
            }
            case "fall": {
                if (!this.variableIncrement.equals(0.0)) {
                    return this.defaultIncrement * Math.pow(this.variableIncrement / this.defaultIncrement, Stats.getStats(player).getFallReduction() / this.maxLvl);
                }
                if (this.customFallIncrement.equals(0.0)) break;
                return this.customFallIncrement;
            }
            case "breath": {
                if (!this.variableIncrement.equals(0.0)) {
                    return this.defaultIncrement * Math.pow(this.variableIncrement / this.defaultIncrement, Stats.getStats(player).getBreathTime() / this.maxLvl);
                }
                if (this.customBreathIncrement.equals(0.0)) break;
                return this.customBreathIncrement;
            }
        }
        return this.defaultIncrement;
    }
}

