/*
 * Decompiled with CFR 0.152.
 */
package me.danielthumaniel.attributesrevamped;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import me.danielthumaniel.attributesrevamped.Config;
import me.danielthumaniel.attributesrevamped.Stats;
import me.danielthumaniel.attributesrevamped.commands.AttributesCommand;
import me.danielthumaniel.attributesrevamped.commands.AttributesTabComplete;
import me.danielthumaniel.attributesrevamped.skills.Breath;
import me.danielthumaniel.attributesrevamped.skills.Endurance;
import me.danielthumaniel.attributesrevamped.skills.Fall;
import me.danielthumaniel.attributesrevamped.skills.Sprint;
import me.danielthumaniel.attributesrevamped.skills.Swim;
import me.danielthumaniel.attributesrevamped.statistics.Metrics;
import me.danielthumaniel.attributesrevamped.statistics.UpdateChecker;
import me.danielthumaniel.attributesrevamped.utils.DataManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AttributesRevamped
extends JavaPlugin {
    DataManager data;
    DataManager configuration;
    Config config;

    public void onEnable() {
        this.data = new DataManager(this, "data.yml");
        this.configuration = new DataManager(this, "configuration.yml");
        this.config = new Config(this.configuration);
        this.loadData();
        this.registerCommand();
        this.registerListeners();
        new Metrics((Plugin)this, 7310);
        if (this.config.updateCheckerEnabled()) {
            UpdateChecker updater = new UpdateChecker(this, 77905);
            try {
                if (updater.checkForUpdates()) {
                    this.getServer().getConsoleSender().sendMessage(ChatColor.DARK_RED + "AttributesRevamped is not up to date! Download the newest version at https://www.spigotmc.org/resources/77905");
                } else {
                    this.getServer().getConsoleSender().sendMessage(ChatColor.DARK_AQUA + "AttributesRevamped is up to date!");
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.SEVERE, e.toString());
            }
        }
    }

    public void onDisable() {
        this.saveData();
    }

    public void registerListeners() {
        List<Listener> listeners = Arrays.asList(new Swim(this, this.config), new Endurance(this.config), new Sprint(this, this.config), new Stats(this.config), new Fall(this.config), new Breath(this, this.config));
        for (Listener listener : listeners) {
            this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        }
    }

    public void registerCommand() {
        PluginCommand attributes = this.getCommand("attributes");
        attributes.setExecutor((CommandExecutor)new AttributesCommand(this.config));
        attributes.setTabCompleter((TabCompleter)new AttributesTabComplete(this.config));
    }

    public void saveData() {
        if (!Stats.getStatsMap().isEmpty()) {
            for (Map.Entry<UUID, Object> entry : Stats.getStatsMap().entrySet()) {
                this.data.getConfig().set("stats." + entry.getKey().toString(), (Object)((Stats)entry.getValue()).serialize());
            }
            this.data.saveConfig();
        }
        if (!Endurance.getHealthMap().isEmpty()) {
            for (Map.Entry<UUID, Object> entry : Endurance.getHealthMap().entrySet()) {
                this.data.getConfig().set("health" + entry.getKey().toString(), entry.getValue());
            }
            this.data.saveConfig();
        }
    }

    public void loadData() {
        if (this.data.getConfig().contains("stats")) {
            this.data.getConfig().getConfigurationSection("stats").getKeys(false).forEach(key -> {
                Stats stats = Stats.getStatsMap().put(UUID.fromString(key), Stats.deserialize(this.data.getConfig().getString("stats." + key), this.config));
            });
        }
        if (this.data.getConfig().contains("health")) {
            this.data.getConfig().getConfigurationSection("health").getKeys(false).forEach(key -> {
                Double d = Endurance.getHealthMap().put(UUID.fromString(key), this.data.getConfig().getDouble("health." + key));
            });
        }
        if (this.data.getConfig().contains("attributesMap")) {
            this.data.getConfig().getConfigurationSection("attributesMap").getKeys(false).forEach(key -> {
                Double[] attrs = ((List)this.data.getConfig().get("attributesMap." + key)).toArray(new Double[3]);
                StringBuilder uuid = new StringBuilder();
                int i = 0;
                while (i <= 31) {
                    uuid.append(key.charAt(i));
                    if (i == 7 || i == 11 || i == 15 || i == 19) {
                        uuid.append("-");
                    }
                    ++i;
                }
                Stats.getStatsMap().put(UUID.fromString(uuid.toString()), new Stats(this.config, attrs[0], attrs[1], attrs[2], 0.0, 0.0));
            });
        }
        new File(this.getDataFolder(), "data.yml").delete();
    }
}

