/*
 * Decompiled with CFR 0.152.
 */
package de.gmx.endermansend.arrowMessages.main;

import de.gmx.endermansend.arrowMessages.config.ConfigHandler;
import de.gmx.endermansend.arrowMessages.items.ItemHandler;
import de.gmx.endermansend.arrowMessages.listeners.BowShootListener;
import de.gmx.endermansend.arrowMessages.listeners.EntityDamageByEntityListener;
import de.gmx.endermansend.arrowMessages.listeners.PlayerPickupArrowListener;
import de.gmx.endermansend.arrowMessages.listeners.PrepareItemCraftListener;
import de.gmx.endermansend.arrowMessages.listeners.ProjectileHitListener;
import org.bukkit.ChatColor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class ArrowMessages
extends JavaPlugin {
    private static ArrowMessages instance;
    private ItemHandler itemHandler;
    private ConfigHandler config;
    private ChatColor titleColor;
    private ChatColor loreColor;
    private String pageEndTag;
    private String lineEndTag;

    public void onEnable() {
        instance = this;
        this.itemHandler = new ItemHandler();
        this.itemHandler.setUpArrowMessageItem();
        this.config = new ConfigHandler();
        this.titleColor = this.config.get.titleColor();
        this.loreColor = this.config.get.loreColor();
        this.pageEndTag = ChatColor.GOLD + "" + this.loreColor;
        this.lineEndTag = ChatColor.DARK_PURPLE + " " + this.loreColor;
        PluginManager manager = this.getServer().getPluginManager();
        manager.registerEvents((Listener)new PrepareItemCraftListener(), (Plugin)this);
        manager.registerEvents((Listener)new BowShootListener(), (Plugin)this);
        manager.registerEvents((Listener)new EntityDamageByEntityListener(), (Plugin)this);
        manager.registerEvents((Listener)new PlayerPickupArrowListener(), (Plugin)this);
        manager.registerEvents((Listener)new ProjectileHitListener(), (Plugin)this);
        this.getLogger().info("Enabled");
    }

    public void onDisable() {
        this.getLogger().info("Disabled");
    }

    public static ArrowMessages getInstance() {
        return instance;
    }

    public ItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public ChatColor getTitleColor() {
        return this.titleColor;
    }

    public ChatColor getLoreColor() {
        return this.loreColor;
    }

    public String getPageEndTag() {
        return this.pageEndTag;
    }

    public String getLineEndTag() {
        return this.lineEndTag;
    }

    public ConfigHandler getConfigHandler() {
        return this.config;
    }
}

