/*
 * Decompiled with CFR 0.152.
 */
package de.gmx.endermansend.arrowMessages.listeners;

import de.gmx.endermansend.arrowMessages.main.ArrowMessages;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ProjectileHitListener
implements Listener {
    private boolean spectralGlowing;

    public ProjectileHitListener() {
        this.spectralGlowing = ArrowMessages.getInstance().getConfigHandler().get.spectralGlowing();
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent e) {
        Projectile projectile = e.getEntity();
        if (!(projectile instanceof Arrow)) {
            return;
        }
        if (projectile.getMetadata("Message").isEmpty()) {
            return;
        }
        projectile.setGlowing(this.spectralGlowing);
        World world = projectile.getWorld();
        Location location = projectile.getLocation();
        world.spawnParticle(Particle.SPELL_WITCH, location, 30);
        world.playSound(location, Sound.ENTITY_ARROW_HIT, 1.5f, 1.0f);
        new ParticleEffects(projectile, world).runTaskTimer((Plugin)ArrowMessages.getInstance(), 0L, 2L);
    }

    class ParticleEffects
    extends BukkitRunnable {
        private Projectile projectile;
        private World world;

        public ParticleEffects(Projectile projectile, World world) {
            this.projectile = projectile;
            this.world = world;
        }

        public void run() {
            if (!this.projectile.isDead()) {
                this.world.spawnParticle(Particle.SPELL_WITCH, this.projectile.getLocation(), 1);
            } else {
                this.cancel();
            }
        }
    }
}

