/*
 * Decompiled with CFR 0.152.
 */
package de.gmx.endermansend.arrowMessages.listeners;

import de.gmx.endermansend.arrowMessages.items.ItemHandler;
import de.gmx.endermansend.arrowMessages.main.ArrowMessages;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class BowShootListener
implements Listener {
    private ItemHandler itemHandler = ArrowMessages.getInstance().getItemHandler();

    @EventHandler
    public void onBowShoot(EntityShootBowEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack arrow = this.getShotArrow(player);
            if (arrow == null) {
                return;
            }
            ItemMeta arrowMeta = arrow.getItemMeta();
            if (this.isArrowMessage(arrowMeta)) {
                e.getProjectile().setMetadata("Title", (MetadataValue)new FixedMetadataValue((Plugin)ArrowMessages.getInstance(), (Object)arrowMeta.getDisplayName()));
                e.getProjectile().setMetadata("Message", (MetadataValue)new FixedMetadataValue((Plugin)ArrowMessages.getInstance(), (Object)arrowMeta.getLore()));
            }
        }
    }

    private ItemStack getShotArrow(Player player) {
        PlayerInventory inventory = player.getInventory();
        ItemStack arrow = inventory.getItemInOffHand();
        if (this.isArrow(arrow)) {
            return arrow;
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            arrow = inventory.getItem(i);
            if (!this.isArrow(arrow)) continue;
            return arrow;
        }
        return null;
    }

    private boolean isArrow(ItemStack arrow) {
        if (arrow == null) {
            return false;
        }
        return arrow.getType().equals((Object)Material.ARROW) || arrow.getType().equals((Object)Material.SPECTRAL_ARROW) || arrow.getType().equals((Object)Material.TIPPED_ARROW);
    }

    private boolean isArrowMessage(ItemMeta arrowMeta) {
        List lore = arrowMeta.getLore();
        if (lore == null) {
            return false;
        }
        if (lore.isEmpty()) {
            return false;
        }
        for (String s : lore) {
            if (s.equals("")) continue;
            return true;
        }
        return false;
    }
}

