/*
 * Decompiled with CFR 0.152.
 */
package de.gmx.endermansend.arrowMessages.listeners;

import de.gmx.endermansend.arrowMessages.main.ArrowMessages;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.MetadataValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrowShotListener
implements Listener {
    protected String pageEndTag;
    protected String lineEndTag;
    private String authorPseudonym;

    public ArrowShotListener() {
        ArrowMessages main = ArrowMessages.getInstance();
        this.pageEndTag = main.getPageEndTag();
        this.lineEndTag = main.getLineEndTag();
        this.authorPseudonym = main.getConfigHandler().get.authorPseudonym();
    }

    protected boolean giveItemsToPlayer(Player player, Arrow arrow) {
        String title = this.getTitle(arrow);
        List<String> message = this.getMessage(arrow);
        if (message == null) {
            return false;
        }
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta bookContent = (BookMeta)book.getItemMeta();
        bookContent.setTitle(title);
        bookContent.setPages(message);
        bookContent.setAuthor(this.authorPseudonym);
        book.setItemMeta((ItemMeta)bookContent);
        player.getInventory().addItem(new ItemStack[]{book});
        return true;
    }

    protected String getTitle(Arrow arrow) {
        List titleData = arrow.getMetadata("Title");
        String title = "";
        for (MetadataValue metaValue : titleData) {
            title = title + metaValue.asString();
        }
        return ChatColor.WHITE + ChatColor.stripColor((String)title);
    }

    protected List<String> getMessage(Arrow arrow) {
        List messageData = arrow.getMetadata("Message");
        if (messageData == null) {
            return null;
        }
        if (messageData.isEmpty()) {
            return null;
        }
        String unformattedMessage = "";
        for (MetadataValue metaValue : messageData) {
            unformattedMessage = unformattedMessage + metaValue.asString();
        }
        ArrayList<String> message = new ArrayList<String>();
        for (String page : unformattedMessage.split(this.pageEndTag)) {
            if (page.startsWith(", ") && page.length() > 2) {
                message.add(ChatColor.BLACK + ChatColor.stripColor((String)page.substring(2).replace(this.lineEndTag, "\n")));
                continue;
            }
            if (page.equals("]")) continue;
            message.add(ChatColor.BLACK + ChatColor.stripColor((String)page.replace(this.lineEndTag, "\n")));
        }
        message.set(0, ((String)message.get(0)).substring(3));
        return message;
    }
}

