/*
 * Decompiled with CFR 0.152.
 */
package de.gmx.endermansend.arrowMessages.config;

import de.gmx.endermansend.arrowMessages.config.GetValuesFromConfig;
import de.gmx.endermansend.arrowMessages.main.ArrowMessages;
import java.io.File;
import java.util.logging.Logger;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigHandler {
    public GetValuesFromConfig get;
    private ArrowMessages main = ArrowMessages.getInstance();
    protected Logger logger = this.main.getLogger();
    private FileConfiguration config;

    public ConfigHandler() {
        if (!this.loadConfig()) {
            this.createDefaultConfig();
        }
        this.get = new GetValuesFromConfig(this);
    }

    public void saveConfig() {
        this.logger.info("Saving config");
        this.main.saveConfig();
        this.logger.info("config saved");
    }

    protected boolean getBooleanFromConfig(String path) {
        if (!this.config.isSet(path) || !this.config.isBoolean(path)) {
            this.noValueFound(path);
        }
        return this.config.getBoolean(path);
    }

    protected String getStringFromConfig(String path) {
        if (!this.config.isSet(path) || !this.config.isString(path)) {
            this.noValueFound(path);
        }
        return this.config.getString(path);
    }

    private void createDefaultConfig() {
        this.logger.info("Creating default config");
        this.main.saveDefaultConfig();
        this.config = this.main.getConfig();
        this.logger.info("Config loaded");
    }

    private boolean loadConfig() {
        this.logger.info("Loading config");
        if (this.configExists()) {
            this.config = this.main.getConfig();
            this.logger.info("Config loaded");
            return true;
        }
        return false;
    }

    private void noValueFound(String path) {
        this.logger.warning("Value is missing or of wrong type: " + path);
        this.logger.warning("Using default value");
        this.logger.warning("Delete config.yml to get a default one");
    }

    private boolean configExists() {
        File[] files = this.main.getDataFolder().listFiles();
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!file.getName().equals("config.yml")) continue;
            return true;
        }
        return false;
    }
}

