/*
 * Decompiled with CFR 0.152.
 */
package me.aroplugins.aroconsole.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import me.aroplugins.aroconsole.AroConsole;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateChecker {
    private URL url;
    private boolean updated = false;
    private boolean checked = false;
    private int pluginID = 85855;
    private String currentVersion = AroConsole.getInstance().getDescription().getVersion();
    private String updatedVersion;

    public UpdateChecker() {
        try {
            this.url = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.pluginID);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void check() {
        if (this.config().getBoolean("aroconsole.checar-update")) {
            if (this.url == null) {
                try {
                    this.url = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.pluginID);
                }
                catch (MalformedURLException ignored) {
                    this.checked = false;
                    return;
                }
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)AroConsole.getInstance(), () -> {
                List<Integer> own;
                String readed = null;
                try {
                    InputStream input = this.url.openStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(input));
                    readed = br.readLine();
                }
                catch (IOException ex) {
                    return;
                }
                if (readed == null) {
                    this.checked = false;
                    this.updated = false;
                    return;
                }
                List<Integer> spigot = this.getNumbers(readed.toCharArray());
                int outdated = this.isUpToDate(spigot, own = this.getNumbers(AroConsole.getInstance().getDescription().getVersion().toCharArray()));
                if (outdated == 0) {
                    this.checked = true;
                    this.updated = true;
                    new BukkitRunnable(){

                        public void run() {
                            Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3[AroConsole] &f\u00bb &cEst\u00e1 correndo a mais recente vers\u00e3o do plugin disponivel!"));
                        }
                    }.runTaskLaterAsynchronously((Plugin)AroConsole.getInstance(), 200L);
                } else if (outdated == 1) {
                    this.checked = true;
                    this.updated = true;
                    new BukkitRunnable(){

                        public void run() {
                            Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3[AroConsole] &f\u00bb &cEst\u00e1 correndo a mais recente (secreta) vers\u00e3o do plugin disponivel!"));
                        }
                    }.runTaskLaterAsynchronously((Plugin)AroConsole.getInstance(), 200L);
                } else if (outdated == 2) {
                    this.checked = true;
                    this.updated = false;
                    new BukkitRunnable(){

                        public void run() {
                            Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3[AroConsole] &f\u00bb &cUma nova atualiza\u00e7\u00e3o est\u00e1 disponivel!"));
                        }
                    }.runTaskLaterAsynchronously((Plugin)AroConsole.getInstance(), 200L);
                }
            });
        }
    }

    private List<Integer> getNumbers(char[] line) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (char c : line) {
            try {
                list.add(Integer.parseInt(String.valueOf(c)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return list;
    }

    private int isUpToDate(List<Integer> spigot, List<Integer> own) {
        int spigotLength = spigot.size();
        int ownLength = own.size();
        int max = 0;
        max = spigotLength > ownLength ? spigotLength : ownLength;
        int outdated = 0;
        for (int i = 0; i < max; ++i) {
            if (spigot.get(i) == null) {
                outdated = 0;
                break;
            }
            if (own.get(i) == null) {
                outdated = 2;
                break;
            }
            if (spigot.get(i) > own.get(i)) {
                outdated = 2;
                break;
            }
            if (own.get(i) <= spigot.get(i)) continue;
            outdated = 1;
            break;
        }
        return outdated;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean hasChecked() {
        return this.checked;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String getUpdatedVersion() {
        return this.updatedVersion;
    }

    public int getPluginID() {
        return this.pluginID;
    }

    protected FileConfiguration config() {
        return AroConsole.getInstance().getConfig();
    }
}

