/*
 * Decompiled with CFR 0.152.
 */
package me.petomka.armorstandeditor.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;

public class Menu {
    private static final String INDENT_SEQUENCE = "\u00bb";
    private ClickEvent.Action action = null;
    private String actionString = "";
    private String message;
    private String description;
    private List<Menu> subMenus = Lists.newArrayList();

    public Menu(String message) {
        this.message = message;
    }

    public Menu(String message, ClickEvent.Action action, String actionString) {
        this.message = message;
        this.action = action;
        this.actionString = actionString;
    }

    public Menu(String message, String description) {
        this.message = message;
        this.description = description;
    }

    public Menu(String message, ClickEvent.Action action, String actionString, String description) {
        this.message = message;
        this.action = action;
        this.actionString = actionString;
        this.description = description;
    }

    public List<BaseComponent[]> toComponents() {
        return this.toComponents(this.message, 0);
    }

    public List<BaseComponent[]> toComponents(String message, int indent) {
        ArrayList components = Lists.newArrayList();
        BaseComponent[] localComponents = TextComponent.fromLegacyText((String)message);
        if (this.action != null) {
            Stream.of(localComponents).forEach(component -> component.setClickEvent(new ClickEvent(this.action, this.actionString)));
        }
        if (this.description != null) {
            Stream.of(localComponents).forEach(component -> component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)this.description))));
        }
        components.add(localComponents);
        this.subMenus.forEach(subMenu -> components.addAll(subMenu.toComponents(indent + 1)));
        return components;
    }

    public List<BaseComponent[]> toComponents(int indentation) {
        return this.toComponents(this.indentation(indentation).concat(this.message), indentation);
    }

    public Menu addSub(Menu menu) {
        if (menu.equals(this)) {
            return this;
        }
        this.subMenus.add(menu);
        return this;
    }

    public boolean removeSub(Menu menu) {
        return this.subMenus.remove(menu);
    }

    public void clearSubs() {
        this.subMenus.clear();
    }

    public void send(CommandSender sender) {
        CommandSender.Spigot spigot = sender.spigot();
        this.toComponents().forEach(arg_0 -> ((CommandSender.Spigot)spigot).sendMessage(arg_0));
    }

    private String indentation(int ind) {
        StringBuilder stringBuilder = new StringBuilder(" ");
        while (ind-- > 1) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(INDENT_SEQUENCE).append("  ");
        return stringBuilder.toString();
    }

    public static String getINDENT_SEQUENCE() {
        return INDENT_SEQUENCE;
    }

    public ClickEvent.Action getAction() {
        return this.action;
    }

    public void setAction(ClickEvent.Action action) {
        this.action = action;
    }

    public String getActionString() {
        return this.actionString;
    }

    public void setActionString(String actionString) {
        this.actionString = actionString;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

