/*
 * Decompiled with CFR 0.152.
 */
package me.petomka.armorstandeditor.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.petomka.armorstandeditor.Main;
import me.petomka.armorstandeditor.config.Messages;
import me.petomka.armorstandeditor.inventory.InventoryMenu;
import me.petomka.armorstandeditor.util.XYZ;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public final class ArmorStandUtils {
    private static final String NBT_TAG_KEY = "armorStandEdit";

    private static NamespacedKey key(String key) {
        return new NamespacedKey((Plugin)Main.getInstance(), key);
    }

    private static void setBoolean(PersistentDataContainer container, String key, boolean value) {
        container.set(ArmorStandUtils.key(key), PersistentDataType.BYTE, (Object)((byte)(value ? 1 : 0)));
    }

    private static boolean getBoolean(PersistentDataContainer container, String key) {
        return (Byte)container.getOrDefault(ArmorStandUtils.key(key), PersistentDataType.BYTE, (Object)0) != 0;
    }

    private static void setByteArray(PersistentDataContainer container, String key, byte[] value) {
        container.set(ArmorStandUtils.key(key), PersistentDataType.BYTE_ARRAY, (Object)value);
    }

    private static byte[] getByteArray(PersistentDataContainer container, String key) {
        return (byte[])container.get(ArmorStandUtils.key(key), PersistentDataType.BYTE_ARRAY);
    }

    private static void setDouble(PersistentDataContainer container, String key, double value) {
        container.set(ArmorStandUtils.key(key), PersistentDataType.DOUBLE, (Object)value);
    }

    private static double getDouble(PersistentDataContainer container, String key) {
        return (Double)container.getOrDefault(ArmorStandUtils.key(key), PersistentDataType.DOUBLE, (Object)0.0);
    }

    private static void setString(PersistentDataContainer container, String key, String value) {
        container.set(ArmorStandUtils.key(key), PersistentDataType.STRING, (Object)value);
    }

    private static String getString(PersistentDataContainer container, String key) {
        return (String)container.get(ArmorStandUtils.key(key), PersistentDataType.STRING);
    }

    public static ItemStack saveToItem(ArmorStand armorStand, Player player) {
        EntityEquipment equipment;
        boolean hasCustomName = armorStand.getCustomName() != null && !armorStand.getCustomName().isEmpty();
        Messages messages = Main.getInstance().getMessages();
        double y = armorStand.getLocation().getY() - player.getLocation().getY();
        String nameReplacement = hasCustomName ? armorStand.getCustomName() : messages.getCopyDefaultName();
        ItemStack copyItem = InventoryMenu.namedItemStack(Material.ARMOR_STAND, Main.colorString(messages.getCopiedArmorStandItemName().replace("{name}", nameReplacement)));
        ItemMeta meta = copyItem.getItemMeta();
        assert (meta != null);
        List lore = Arrays.stream(messages.getCopiedArmorStandLore().split("\\\\n")).map(Main::colorString).collect(Collectors.toList());
        meta.setLore(lore);
        copyItem.setItemMeta(meta);
        PersistentDataContainer parentContainer = meta.getPersistentDataContainer();
        PersistentDataContainer dataContainer = parentContainer.getAdapterContext().newPersistentDataContainer();
        ArmorStandUtils.setBoolean(dataContainer, "arms", armorStand.hasArms());
        ArmorStandUtils.setBoolean(dataContainer, "baseplate", armorStand.hasBasePlate());
        ArmorStandUtils.setBoolean(dataContainer, "small", armorStand.isSmall());
        ArmorStandUtils.setBoolean(dataContainer, "invulnerable", armorStand.isInvulnerable());
        ArmorStandUtils.setBoolean(dataContainer, "gravity", armorStand.hasGravity());
        ArmorStandUtils.setBoolean(dataContainer, "visible", armorStand.isVisible());
        ArmorStandUtils.setBoolean(dataContainer, "customNameVisible", armorStand.isCustomNameVisible());
        ArmorStandUtils.setBoolean(dataContainer, "glowing", armorStand.isGlowing());
        ArmorStandUtils.setByteArray(dataContainer, "headPose", ArmorStandUtils.serializeEulerAngle(armorStand.getHeadPose()));
        ArmorStandUtils.setByteArray(dataContainer, "leftArmPose", ArmorStandUtils.serializeEulerAngle(armorStand.getLeftArmPose()));
        ArmorStandUtils.setByteArray(dataContainer, "rightArmPose", ArmorStandUtils.serializeEulerAngle(armorStand.getRightArmPose()));
        ArmorStandUtils.setByteArray(dataContainer, "leftLegPose", ArmorStandUtils.serializeEulerAngle(armorStand.getLeftLegPose()));
        ArmorStandUtils.setByteArray(dataContainer, "rightLegPose", ArmorStandUtils.serializeEulerAngle(armorStand.getRightLegPose()));
        ArmorStandUtils.setByteArray(dataContainer, "bodyPose", ArmorStandUtils.serializeEulerAngle(armorStand.getBodyPose()));
        ArmorStandUtils.setDouble(dataContainer, "rotation", armorStand.getLocation().getYaw());
        ArmorStandUtils.setDouble(dataContainer, "y", y);
        if (hasCustomName) {
            ArmorStandUtils.setString(dataContainer, "customName", armorStand.getCustomName());
        }
        if ((equipment = armorStand.getEquipment()) != null) {
            if (equipment.getHelmet() != null) {
                ArmorStandUtils.setByteArray(dataContainer, "helmet", ArmorStandUtils.serializeBukkitObject((ConfigurationSerializable)equipment.getHelmet()));
            }
            if (equipment.getChestplate() != null) {
                ArmorStandUtils.setByteArray(dataContainer, "chestplate", ArmorStandUtils.serializeBukkitObject((ConfigurationSerializable)equipment.getChestplate()));
            }
            if (equipment.getLeggings() != null) {
                ArmorStandUtils.setByteArray(dataContainer, "leggings", ArmorStandUtils.serializeBukkitObject((ConfigurationSerializable)equipment.getLeggings()));
            }
            if (equipment.getBoots() != null) {
                ArmorStandUtils.setByteArray(dataContainer, "boots", ArmorStandUtils.serializeBukkitObject((ConfigurationSerializable)equipment.getBoots()));
            }
            if (equipment.getItemInMainHand() != null) {
                ArmorStandUtils.setByteArray(dataContainer, "itemInHand", ArmorStandUtils.serializeBukkitObject((ConfigurationSerializable)equipment.getItemInMainHand()));
            }
            if (equipment.getItemInOffHand() != null) {
                ArmorStandUtils.setByteArray(dataContainer, "itemInOffHand", ArmorStandUtils.serializeBukkitObject((ConfigurationSerializable)equipment.getItemInOffHand()));
            }
        }
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            for (ArmorStand.LockType lockType : ArmorStand.LockType.values()) {
                boolean locked = armorStand.hasEquipmentLock(equipmentSlot, lockType);
                ArmorStandUtils.setBoolean(dataContainer, ArmorStandUtils.getLockTypeKey(equipmentSlot, lockType), locked);
            }
        }
        parentContainer.set(ArmorStandUtils.key(NBT_TAG_KEY), PersistentDataType.TAG_CONTAINER, (Object)dataContainer);
        copyItem.setItemMeta(meta);
        return copyItem;
    }

    public static boolean isCopiedArmorStand(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        PersistentDataContainer container = itemMeta.getPersistentDataContainer();
        return container.has(ArmorStandUtils.key(NBT_TAG_KEY), PersistentDataType.TAG_CONTAINER);
    }

    public static boolean isCopyWorthIt(ArmorStand armorStand) {
        boolean item;
        boolean euler;
        boolean bl = euler = ArmorStandUtils.isEulerNormal(armorStand.getHeadPose(), 0.2) && ArmorStandUtils.isEulerNormal(armorStand.getLeftArmPose(), 0.3) && ArmorStandUtils.isEulerNormal(armorStand.getRightArmPose(), 0.3) && ArmorStandUtils.isEulerNormal(armorStand.getLeftLegPose(), 0.1) && ArmorStandUtils.isEulerNormal(armorStand.getRightLegPose(), 0.1) && ArmorStandUtils.isEulerNormal(armorStand.getBodyPose(), 0.2);
        if (!euler) {
            return true;
        }
        boolean bl2 = item = ArmorStandUtils.isItemThere(armorStand.getHelmet()) || ArmorStandUtils.isItemThere(armorStand.getChestplate()) || ArmorStandUtils.isItemThere(armorStand.getLeggings()) || ArmorStandUtils.isItemThere(armorStand.getBoots()) || ArmorStandUtils.isItemThere(armorStand.getEquipment().getItemInMainHand()) || ArmorStandUtils.isItemThere(armorStand.getEquipment().getItemInOffHand());
        if (item) {
            return true;
        }
        return armorStand.isGlowing() || armorStand.hasArms() || !armorStand.hasBasePlate() || !armorStand.hasGravity() || armorStand.isInvulnerable() || armorStand.isCustomNameVisible() || armorStand.isSmall();
    }

    private static boolean isEulerNormal(EulerAngle angle, double threshold) {
        double x = Math.abs(angle.getX());
        double y = Math.abs(angle.getY());
        double z = Math.abs(angle.getZ());
        return x <= threshold && x >= -threshold && y <= threshold && y >= -threshold && z <= threshold && z >= -threshold;
    }

    private static boolean isItemThere(ItemStack itemStack) {
        return itemStack != null && itemStack.getType() != Material.AIR;
    }

    public static void loadFromItem(ItemStack itemStack, ArmorStand armorStand) {
        if (!ArmorStandUtils.isCopiedArmorStand(itemStack)) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        PersistentDataContainer parentContainer = itemMeta.getPersistentDataContainer();
        PersistentDataContainer dataContainer = (PersistentDataContainer)parentContainer.get(ArmorStandUtils.key(NBT_TAG_KEY), PersistentDataType.TAG_CONTAINER);
        if (dataContainer == null) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Wrong value stored for NBT key + \"armorStandEdit\"");
            return;
        }
        armorStand.setArms(ArmorStandUtils.getBoolean(dataContainer, "arms"));
        armorStand.setBasePlate(ArmorStandUtils.getBoolean(dataContainer, "baseplate"));
        armorStand.setSmall(ArmorStandUtils.getBoolean(dataContainer, "small"));
        armorStand.setInvulnerable(ArmorStandUtils.getBoolean(dataContainer, "invulnerable"));
        armorStand.setGravity(ArmorStandUtils.getBoolean(dataContainer, "gravity"));
        armorStand.setVisible(ArmorStandUtils.getBoolean(dataContainer, "visible"));
        armorStand.setCustomNameVisible(ArmorStandUtils.getBoolean(dataContainer, "customNameVisible"));
        armorStand.setGlowing(ArmorStandUtils.getBoolean(dataContainer, "glowing"));
        armorStand.setHeadPose(ArmorStandUtils.deserializeToEuler(ArmorStandUtils.getByteArray(dataContainer, "headPose")));
        armorStand.setLeftArmPose(ArmorStandUtils.deserializeToEuler(ArmorStandUtils.getByteArray(dataContainer, "leftArmPose")));
        armorStand.setRightArmPose(ArmorStandUtils.deserializeToEuler(ArmorStandUtils.getByteArray(dataContainer, "rightArmPose")));
        armorStand.setLeftLegPose(ArmorStandUtils.deserializeToEuler(ArmorStandUtils.getByteArray(dataContainer, "leftLegPose")));
        armorStand.setRightLegPose(ArmorStandUtils.deserializeToEuler(ArmorStandUtils.getByteArray(dataContainer, "rightLegPose")));
        armorStand.setBodyPose(ArmorStandUtils.deserializeToEuler(ArmorStandUtils.getByteArray(dataContainer, "bodyPose")));
        float yaw = (float)ArmorStandUtils.getDouble(dataContainer, "rotation");
        double y = ArmorStandUtils.getDouble(dataContainer, "y");
        if (dataContainer.has(ArmorStandUtils.key("customName"), PersistentDataType.STRING)) {
            armorStand.setCustomName(ArmorStandUtils.getString(dataContainer, "customName"));
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> {
            Location location = armorStand.getLocation();
            location.add(0.0, y, 0.0);
            armorStand.teleport(location);
        }, 1L);
        Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> {
            Location location = armorStand.getLocation();
            location.setYaw(yaw);
            armorStand.teleport(location);
        }, 2L);
        EntityEquipment equipment = armorStand.getEquipment();
        if (equipment != null) {
            if (dataContainer.has(ArmorStandUtils.key("helmet"), PersistentDataType.BYTE_ARRAY)) {
                equipment.setHelmet((ItemStack)ArmorStandUtils.deserializeBukkitObject(ArmorStandUtils.getByteArray(dataContainer, "helmet")));
            }
            if (dataContainer.has(ArmorStandUtils.key("chestplate"), PersistentDataType.BYTE_ARRAY)) {
                equipment.setChestplate((ItemStack)ArmorStandUtils.deserializeBukkitObject(ArmorStandUtils.getByteArray(dataContainer, "chestplate")));
            }
            if (dataContainer.has(ArmorStandUtils.key("leggings"), PersistentDataType.BYTE_ARRAY)) {
                equipment.setLeggings((ItemStack)ArmorStandUtils.deserializeBukkitObject(ArmorStandUtils.getByteArray(dataContainer, "leggings")));
            }
            if (dataContainer.has(ArmorStandUtils.key("boots"), PersistentDataType.BYTE_ARRAY)) {
                equipment.setBoots((ItemStack)ArmorStandUtils.deserializeBukkitObject(ArmorStandUtils.getByteArray(dataContainer, "boots")));
            }
            if (dataContainer.has(ArmorStandUtils.key("itemInHand"), PersistentDataType.BYTE_ARRAY)) {
                equipment.setItemInMainHand((ItemStack)ArmorStandUtils.deserializeBukkitObject(ArmorStandUtils.getByteArray(dataContainer, "itemInHand")));
            }
            if (dataContainer.has(ArmorStandUtils.key("itemInOffHand"), PersistentDataType.BYTE_ARRAY)) {
                equipment.setItemInOffHand((ItemStack)ArmorStandUtils.deserializeBukkitObject(ArmorStandUtils.getByteArray(dataContainer, "itemInOffHand")));
            }
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            for (ArmorStand.LockType lockType : ArmorStand.LockType.values()) {
                boolean locked = ArmorStandUtils.getBoolean(dataContainer, ArmorStandUtils.getLockTypeKey(slot, lockType));
                if (locked) {
                    armorStand.addEquipmentLock(slot, lockType);
                    continue;
                }
                armorStand.removeEquipmentLock(slot, lockType);
            }
        }
    }

    private static String getLockTypeKey(EquipmentSlot slot, ArmorStand.LockType lockType) {
        return slot.name() + "." + lockType.name();
    }

    private static byte[] serializeEulerAngle(EulerAngle angle) {
        XYZ xyz = new XYZ(angle.getX(), angle.getY(), angle.getZ());
        return ArmorStandUtils.serializeObject(xyz);
    }

    private static byte[] serializeObject(Serializable serializable) {
        byte[] byArray;
        ObjectOutputStream out = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(serializable);
            out.flush();
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        bos.close();
        return byArray;
    }

    private static EulerAngle deserializeToEuler(byte[] bytes) {
        XYZ xyz = (XYZ)ArmorStandUtils.deserializeObject(bytes);
        if (xyz == null) {
            return new EulerAngle(0.0, 0.0, 0.0);
        }
        return new EulerAngle(xyz.x, xyz.y, xyz.z);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Object deserializeObject(byte[] bytes) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            Object object;
            try (ObjectInputStream in = new ObjectInputStream(bis);){
                object = in.readObject();
            }
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] serializeBukkitObject(ConfigurationSerializable serializable) {
        byte[] byArray;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            try (BukkitObjectOutputStream bukkitOut = new BukkitObjectOutputStream((OutputStream)byteOut);){
                bukkitOut.writeObject((Object)serializable);
            }
            byArray = byteOut.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteOut.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        byteOut.close();
        return byArray;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static ConfigurationSerializable deserializeBukkitObject(byte[] bytes) {
        try (ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes);){
            ConfigurationSerializable configurationSerializable;
            try (BukkitObjectInputStream bukkitIn = new BukkitObjectInputStream((InputStream)byteIn);){
                configurationSerializable = (ConfigurationSerializable)bukkitIn.readObject();
            }
            return configurationSerializable;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ArmorStandUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

