/*
 * Decompiled with CFR 0.152.
 */
package me.petomka.armorstandeditor.net.cubespace.Yamler.Config;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.ConfigSection;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.Converter.Array;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.Converter.Config;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.Converter.Converter;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.Converter.List;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.Converter.Map;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.Converter.Primitive;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.Converter.Set;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.InvalidConverterException;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.PreserveStatic;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.YamlConfig;

public class InternalConverter {
    private LinkedHashSet<Converter> converters = new LinkedHashSet();
    private java.util.List<Class> customConverters = new ArrayList<Class>();

    public InternalConverter() {
        try {
            this.addConverter(Primitive.class);
            this.addConverter(Config.class);
            this.addConverter(List.class);
            this.addConverter(Map.class);
            this.addConverter(Array.class);
            this.addConverter(Set.class);
        }
        catch (InvalidConverterException e) {
            throw new IllegalStateException(e);
        }
    }

    public void addConverter(Class converter) throws InvalidConverterException {
        if (!Converter.class.isAssignableFrom(converter)) {
            throw new InvalidConverterException("Converter does not implement the Interface Converter");
        }
        try {
            Converter converter1 = (Converter)converter.getConstructor(InternalConverter.class).newInstance(this);
            this.converters.add(converter1);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidConverterException("Converter does not implement a Constructor which takes the InternalConverter instance", e);
        }
        catch (InvocationTargetException e) {
            throw new InvalidConverterException("Converter could not be invoked", e);
        }
        catch (InstantiationException e) {
            throw new InvalidConverterException("Converter could not be instantiated", e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidConverterException("Converter does not implement a public Constructor which takes the InternalConverter instance", e);
        }
    }

    public Converter getConverter(Class type) {
        for (Converter converter : this.converters) {
            if (!converter.supports(type)) continue;
            return converter;
        }
        return null;
    }

    public void fromConfig(YamlConfig config, Field field, ConfigSection root, String path) throws Exception {
        Object obj = field.get(config);
        if (obj != null) {
            Converter converter = this.getConverter(obj.getClass());
            if (converter != null) {
                if (Modifier.isStatic(field.getModifiers())) {
                    if (!field.isAnnotationPresent(PreserveStatic.class)) {
                        return;
                    }
                    PreserveStatic staticConfig = field.getAnnotation(PreserveStatic.class);
                    if (!staticConfig.value()) {
                        return;
                    }
                    field.set(null, converter.fromConfig(field.getType(), root.get(path), field.getGenericType() instanceof ParameterizedType ? (ParameterizedType)field.getGenericType() : null));
                    return;
                }
                field.set(config, converter.fromConfig(obj.getClass(), root.get(path), field.getGenericType() instanceof ParameterizedType ? (ParameterizedType)field.getGenericType() : null));
                return;
            }
            converter = this.getConverter(field.getType());
            if (converter != null) {
                if (Modifier.isStatic(field.getModifiers())) {
                    if (!field.isAnnotationPresent(PreserveStatic.class)) {
                        return;
                    }
                    PreserveStatic staticConfig = field.getAnnotation(PreserveStatic.class);
                    if (!staticConfig.value()) {
                        return;
                    }
                    field.set(null, converter.fromConfig(field.getType(), root.get(path), field.getGenericType() instanceof ParameterizedType ? (ParameterizedType)field.getGenericType() : null));
                    return;
                }
                field.set(config, converter.fromConfig(field.getType(), root.get(path), field.getGenericType() instanceof ParameterizedType ? (ParameterizedType)field.getGenericType() : null));
                return;
            }
        } else {
            Converter converter = this.getConverter(field.getType());
            if (converter != null) {
                if (Modifier.isStatic(field.getModifiers())) {
                    if (!field.isAnnotationPresent(PreserveStatic.class)) {
                        return;
                    }
                    PreserveStatic staticConfig = field.getAnnotation(PreserveStatic.class);
                    if (!staticConfig.value()) {
                        return;
                    }
                    field.set(null, converter.fromConfig(field.getType(), root.get(path), field.getGenericType() instanceof ParameterizedType ? (ParameterizedType)field.getGenericType() : null));
                    return;
                }
                field.set(config, converter.fromConfig(field.getType(), root.get(path), field.getGenericType() instanceof ParameterizedType ? (ParameterizedType)field.getGenericType() : null));
                return;
            }
        }
        if (Modifier.isStatic(field.getModifiers())) {
            if (!field.isAnnotationPresent(PreserveStatic.class)) {
                return;
            }
            PreserveStatic staticConfig = field.getAnnotation(PreserveStatic.class);
            if (!staticConfig.value()) {
                return;
            }
            field.set(null, root.get(path));
            return;
        }
        field.set(config, root.get(path));
    }

    public void toConfig(YamlConfig config, Field field, ConfigSection root, String path) throws Exception {
        Object obj = field.get(config);
        if (obj != null) {
            Converter converter = this.getConverter(obj.getClass());
            if (converter != null) {
                root.set(path, converter.toConfig(obj.getClass(), obj, field.getGenericType() instanceof ParameterizedType ? (ParameterizedType)field.getGenericType() : null));
                return;
            }
            converter = this.getConverter(field.getType());
            if (converter != null) {
                root.set(path, converter.toConfig(field.getType(), obj, field.getGenericType() instanceof ParameterizedType ? (ParameterizedType)field.getGenericType() : null));
                return;
            }
        }
        root.set(path, obj);
    }

    public java.util.List<Class> getCustomConverters() {
        return new ArrayList<Class>(this.customConverters);
    }

    public void addCustomConverter(Class addConverter) throws InvalidConverterException {
        this.addConverter(addConverter);
        this.customConverters.add(addConverter);
    }
}

