/*
 * Decompiled with CFR 0.152.
 */
package me.petomka.armorstandeditor.listener;

import java.util.HashSet;
import java.util.Set;
import me.petomka.armorstandeditor.Main;
import me.petomka.armorstandeditor.handler.ArmorStandEditHandler;
import me.petomka.armorstandeditor.handler.AttachedCommandsHandler;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.plugin.Plugin;

public class AttachedCommandsListener
implements Listener {
    private static final Set<Object> eventsToIgnore = new HashSet<Object>();

    public AttachedCommandsListener(Main plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public static void addIgnoreEvent(Object event) {
        eventsToIgnore.add(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInteract(PlayerInteractAtEntityEvent event) {
        if (eventsToIgnore.remove(event)) {
            return;
        }
        if (Main.getEventsToIgnore().contains(event)) {
            return;
        }
        if (ArmorStandEditHandler.getInstance().isEditingPlayer(event.getPlayer().getUniqueId())) {
            return;
        }
        Entity rightClicked = event.getRightClicked();
        if (!(rightClicked instanceof ArmorStand)) {
            return;
        }
        if (!AttachedCommandsHandler.getInstance().hasCommands(rightClicked.getUniqueId())) {
            return;
        }
        AttachedCommandsHandler.getInstance().performCommands(event.getPlayer(), rightClicked.getUniqueId());
        event.setCancelled(true);
    }
}

