/*
 * Decompiled with CFR 0.152.
 */
package me.petomka.armorstandeditor.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.petomka.armorstandeditor.Main;
import me.petomka.armorstandeditor.config.Messages;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class InventoryMenu
implements Listener {
    private static final ItemStack DEFAULT_ITEM = InventoryMenu.hideDisplayName(new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE));
    private static final ItemStack DARK_ITEM = InventoryMenu.hideDisplayName(new ItemStack(Material.BLACK_STAINED_GLASS_PANE));
    private static final Map<UUID, InventoryMenu> openedInventories = new HashMap<UUID, InventoryMenu>();
    private static final Set<InventoryAction> LEGIT_ACTIONS = ImmutableSet.of((Object)InventoryAction.PICKUP_ALL, (Object)InventoryAction.PICKUP_HALF, (Object)InventoryAction.PICKUP_ONE, (Object)InventoryAction.PICKUP_SOME, (Object)InventoryAction.CLONE_STACK, (Object)InventoryAction.PLACE_ALL, (Object[])new InventoryAction[]{InventoryAction.SWAP_WITH_CURSOR, InventoryAction.PLACE_ONE, InventoryAction.PLACE_SOME});
    private static ItemStack BACK_ITEM;
    private Map<Integer, BiConsumer<Player, ItemStack>> clickHandlers = Maps.newHashMap();
    private Set<Integer> modifiableSlots = Sets.newHashSet();
    private Inventory inventory;
    private boolean locked = false;
    private BiConsumer<Player, ItemStack> defaultClickHandler;
    private Runnable backHandler;
    private Runnable closeHandler;
    private final int rows;

    public static void reloadItemNames() {
        Messages messages = Main.getInstance().getMessages();
        BACK_ITEM = InventoryMenu.namedItemStack(Material.IRON_DOOR, messages.getInventory_backItem());
    }

    public static ItemStack namedItemStack(Material material, String name) {
        ItemStack stack = new ItemStack(material);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName(Main.colorString(name));
        stack.setItemMeta(meta);
        return stack;
    }

    private static ItemStack hideDisplayName(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName("" + ChatColor.BLACK);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public InventoryMenu(@Nonnull String title, int rows, @Nullable Consumer<Player> defaultClickHandler, @Nullable Runnable backHandler) {
        this(title, rows, (Player player, ItemStack itemStack) -> defaultClickHandler.accept((Player)player), backHandler);
    }

    public InventoryMenu(@Nonnull String title, int rows, @Nullable BiConsumer<Player, ItemStack> defaultClickHandler, @Nullable Runnable backHandler) {
        Preconditions.checkNotNull((Object)title, (Object)"title");
        Preconditions.checkArgument((rows <= 6 ? 1 : 0) != 0, (Object)"Only 6 rows are possible!");
        if (defaultClickHandler == null) {
            defaultClickHandler = (player, itemStack) -> this.unlock();
        }
        this.rows = rows;
        this.defaultClickHandler = defaultClickHandler;
        this.backHandler = backHandler;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Main.getInstance());
        this.inventory = Bukkit.createInventory(null, (int)(9 * rows), (String)title);
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            this.inventory.setItem(i, DEFAULT_ITEM);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onClick(InventoryClickEvent event) {
        if (event.getClickedInventory() == null) {
            return;
        }
        if (!this.inventory.getViewers().contains(event.getWhoClicked())) {
            return;
        }
        if (!event.getClickedInventory().equals(this.inventory)) {
            return;
        }
        if (!LEGIT_ACTIONS.contains(event.getAction())) {
            event.setCancelled(true);
        }
        if (this.locked) {
            event.setCancelled(true);
            return;
        }
        if (!this.modifiableSlots.contains(event.getSlot())) {
            event.setCancelled(true);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> this.clickHandlers.getOrDefault(event.getSlot(), this.defaultClickHandler).accept((Player)event.getWhoClicked(), event.getCurrentItem()), 1L);
        this.locked = true;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!this.inventory.getViewers().contains(event.getWhoClicked())) {
            return;
        }
        if (!event.getInventory().equals(this.inventory)) {
            return;
        }
        event.getNewItems().forEach((integer, itemStack) -> Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> this.clickHandlers.getOrDefault(integer, this.defaultClickHandler).accept((Player)event.getWhoClicked(), (ItemStack)itemStack), 1L));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onClose(InventoryCloseEvent event) {
        if (!event.getInventory().equals(this.inventory)) {
            return;
        }
        this.locked = true;
        HandlerList.unregisterAll((Listener)this);
        openedInventories.remove(event.getPlayer().getUniqueId());
        if (this.closeHandler != null) {
            Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), this.closeHandler, 1L);
        }
    }

    public void open(Player player) {
        player.openInventory(this.inventory);
        openedInventories.put(player.getUniqueId(), this);
    }

    public void fillBorder() {
        for (int i2 = 0; i2 < 9; ++i2) {
            for (int j = 0; j < this.rows; ++j) {
                if (j != 0 && j != this.rows - 1 && i2 != 0 && i2 != 8) continue;
                this.addItemAndClickHandler(DARK_ITEM, j, i2, this.defaultClickHandler);
            }
        }
        if (this.backHandler != null) {
            this.addItemAndClickHandler(BACK_ITEM, this.rows - 1, 8, (p, i) -> this.backHandler.run());
        } else {
            this.addItemAndClickHandler(DARK_ITEM, this.rows - 1, 8, this.defaultClickHandler);
        }
    }

    public void addBackDoor() {
        this.addItemAndClickHandler(BACK_ITEM, this.rows - 1, 8, (p, i) -> this.backHandler.run());
    }

    public void fill(ItemStack itemStack) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                this.addItemAndClickHandler(itemStack, j, i, null);
            }
        }
    }

    public void unlock() {
        Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> this.setLocked(false), 1L);
    }

    public void addModifiableSlot(int row, int column) {
        this.modifiableSlots.add(row * 9 + column);
    }

    public void addModifiableSlot(int indexedSlot) {
        this.modifiableSlots.add(indexedSlot);
    }

    public void addItemAndClickHandler(@Nullable ItemStack itemStack, int row, int column, @Nullable BiConsumer<Player, ItemStack> clickHandler) {
        this.addItemAndClickHandler(itemStack, 9 * row + column, clickHandler);
    }

    public void addItemAndClickHandler(@Nullable ItemStack itemStack, int indexedSlot, @Nullable BiConsumer<Player, ItemStack> clickHandler) {
        this.inventory.setItem(indexedSlot, itemStack);
        if (clickHandler != null) {
            this.clickHandlers.put(indexedSlot, clickHandler);
        }
    }

    public static Map<UUID, InventoryMenu> getOpenedInventories() {
        return openedInventories;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public BiConsumer<Player, ItemStack> getDefaultClickHandler() {
        return this.defaultClickHandler;
    }

    public Runnable getBackHandler() {
        return this.backHandler;
    }

    public Runnable getCloseHandler() {
        return this.closeHandler;
    }

    public void setCloseHandler(Runnable closeHandler) {
        this.closeHandler = closeHandler;
    }
}

