/*
 * Decompiled with CFR 0.152.
 */
package me.petomka.armorstandeditor.handler;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.petomka.armorstandeditor.Main;
import me.petomka.armorstandeditor.handler.ArmorStandEditHandler;
import me.petomka.armorstandeditor.handler.Part;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class ScoreboardHandler {
    private static final AtomicReference<Object> instance = new AtomicReference();
    private static final String SCORBOARD_OBJECTIVE_NAME = "asEdit";
    private static final String SCOREBOARD_TEAM_START = "T";
    private Map<UUID, Scoreboard> registeredBoards = Maps.newHashMap();
    private Map<UUID, Scoreboard> previousScoreboards = new WeakHashMap<UUID, Scoreboard>();

    public boolean registerPlayer(@Nonnull UUID player) {
        Objective objective;
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Player thePlayer = Bukkit.getPlayer((UUID)player);
        if (thePlayer == null) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Cannot register scoreboard for unknown player with UUID " + player);
            return false;
        }
        Part editedPart = ArmorStandEditHandler.getInstance().getEditingPart(player);
        if (editedPart == null) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Cannot register scoreboard for not editing player " + thePlayer.getName());
            return false;
        }
        Scoreboard scoreboard = thePlayer.getScoreboard();
        if (!this.registeredBoards.containsValue(scoreboard)) {
            this.previousScoreboards.put(player, thePlayer.getScoreboard());
            scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
            objective = scoreboard.registerNewObjective(SCORBOARD_OBJECTIVE_NAME, "dummy", editedPart.getEditingInfo());
        } else {
            scoreboard = this.registeredBoards.get(player);
            objective = scoreboard.getObjective(SCORBOARD_OBJECTIVE_NAME);
        }
        this.registeredBoards.put(player, scoreboard);
        if (objective == null) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Objective for registered scoreboard was missing!");
            return false;
        }
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        thePlayer.setScoreboard(scoreboard);
        this.updatePlayer(player);
        return true;
    }

    public void unregisterPlayer(@Nonnull UUID player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Player thePlayer = Bukkit.getPlayer((UUID)player);
        if (thePlayer == null) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Cannot unregister Scoreboard for non-existent player with UUID " + player);
            return;
        }
        this.registeredBoards.remove(player);
        Scoreboard scoreboard = this.previousScoreboards.get(player);
        if (scoreboard != null) {
            thePlayer.setScoreboard(scoreboard);
        } else {
            thePlayer.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
        }
    }

    public boolean updatePlayer(@Nonnull UUID player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Player thePlayer = Bukkit.getPlayer((UUID)player);
        if (thePlayer == null) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Cannot update scoreboard for unknown player with UUID " + player);
            return false;
        }
        Scoreboard scoreboard = thePlayer.getScoreboard();
        if (scoreboard == null || scoreboard.equals(Bukkit.getScoreboardManager().getMainScoreboard())) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Tried updating foreign scoreboard!");
            return false;
        }
        Objective objective = scoreboard.getObjective(SCORBOARD_OBJECTIVE_NAME);
        if (objective == null) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Scoreboard used to display info for " + thePlayer.getName() + " is missing it's objective!");
            return false;
        }
        Part editedPart = ArmorStandEditHandler.getInstance().getEditingPart(player);
        if (editedPart == null) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Tried updating scoreboard for non editing player!");
            return false;
        }
        int teamNo = 0;
        Set<ArmorStand> armorStands = ArmorStandEditHandler.getInstance().editedArmorStands.get(player);
        if (armorStands == null || armorStands.size() != 1) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Player " + thePlayer.getName() + " does not have exactly one armorstand to edit, but has " + (Serializable)(armorStands == null ? "none" : Integer.valueOf(armorStands.size())));
            return false;
        }
        objective.setDisplayName(editedPart.getEditingInfo());
        Map<String, Integer> scoreboardInfo = editedPart.getScoreboardInfo((ArmorStand)armorStands.stream().findAny().get());
        HashSet unusedTeams = Sets.newHashSet((Iterable)scoreboard.getTeams());
        for (Map.Entry<String, Integer> scoreboardLine : scoreboardInfo.entrySet()) {
            String teamName = SCOREBOARD_TEAM_START + teamNo++;
            String teamEntry = "" + ChatColor.values()[teamNo];
            Team team = scoreboard.getTeam(teamName);
            if (team == null) {
                team = scoreboard.registerNewTeam(teamName);
                team.addEntry(teamEntry);
            } else {
                unusedTeams.remove(team);
            }
            team.setPrefix(ChatColor.translateAlternateColorCodes((char)'&', (String)scoreboardLine.getKey()));
            objective.getScore(teamEntry).setScore(scoreboardLine.getValue().intValue());
        }
        for (Team unusedTeam : unusedTeams) {
            unusedTeam.getEntries().forEach(arg_0 -> ((Scoreboard)scoreboard).resetScores(arg_0));
            unusedTeam.unregister();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScoreboardHandler getInstance() {
        Object value = instance.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                value = instance.get();
                if (value == null) {
                    ScoreboardHandler actualValue = new ScoreboardHandler();
                    value = actualValue == null ? instance : actualValue;
                    instance.set(value);
                }
            }
        }
        return (ScoreboardHandler)(value == instance ? null : value);
    }
}

