/*
 * Decompiled with CFR 0.152.
 */
package me.petomka.armorstandeditor.handler;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.petomka.armorstandeditor.Main;
import me.petomka.armorstandeditor.config.DefaultConfig;
import me.petomka.armorstandeditor.config.Messages;
import me.petomka.armorstandeditor.handler.Accuracy;
import me.petomka.armorstandeditor.handler.ArmorStandEditHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class BossBarHandler {
    private static final AtomicReference<Object> instance = new AtomicReference();
    private Map<UUID, BossBar> playerBossBars = Maps.newHashMap();

    public boolean registerPlayer(@Nonnull UUID player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        if (this.isRegistered(player)) {
            return this.updatePlayerBar(player);
        }
        Player thePlayer = Bukkit.getPlayer((UUID)player);
        if (thePlayer == null) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Cannot register bossbar for unknown player with unknown UUID " + player);
            return false;
        }
        BossBar bar = this.createNewBossBar();
        if (bar != null) {
            this.playerBossBars.put(player, bar);
            bar.addPlayer(thePlayer);
            this.updatePlayerBar(player);
            return true;
        }
        return false;
    }

    public void unregisterPlayer(@Nonnull UUID player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Optional.ofNullable(this.playerBossBars.remove(player)).ifPresent(BossBar::removeAll);
    }

    public boolean isRegistered(@Nonnull UUID player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        return this.playerBossBars.containsKey(player);
    }

    public boolean updatePlayerBar(@Nonnull UUID player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        BossBar bar = this.playerBossBars.get(player);
        if (bar == null) {
            return false;
        }
        Accuracy playerAccuracy = ArmorStandEditHandler.getInstance().editingAccuracy.get(player);
        String title = Main.getInstance().getMessages().getBossBarTitle();
        title = ChatColor.translateAlternateColorCodes((char)'&', (String)title);
        title = title.replace("{size}", ChatColor.translateAlternateColorCodes((char)'&', (String)playerAccuracy.getName()));
        bar.setProgress((double)(playerAccuracy.ordinal() + 1) / (double)Accuracy.values().length);
        bar.setTitle(title);
        return true;
    }

    private BossBar createNewBossBar() {
        BarStyle barStyle;
        BarColor barColor;
        Messages messages = Main.getInstance().getMessages();
        DefaultConfig config = Main.getInstance().getDefaultConfig();
        try {
            barColor = BarColor.valueOf((String)config.getBossBarColor());
        }
        catch (Exception exc) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Invalid barColor \"" + config.getBossBarColor() + "\"", exc);
            return null;
        }
        try {
            barStyle = BarStyle.valueOf((String)config.getBossBarStyle());
        }
        catch (Exception exc) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Invalid barStyle \"" + config.getBossBarStyle() + "\"", exc);
            return null;
        }
        return Bukkit.createBossBar((String)messages.getBossBarTitle(), (BarColor)barColor, (BarStyle)barStyle, (BarFlag[])new BarFlag[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BossBarHandler getInstance() {
        Object value = instance.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                value = instance.get();
                if (value == null) {
                    BossBarHandler actualValue = new BossBarHandler();
                    value = actualValue == null ? instance : actualValue;
                    instance.set(value);
                }
            }
        }
        return (BossBarHandler)(value == instance ? null : value);
    }
}

