/*
 * Decompiled with CFR 0.152.
 */
package me.petomka.armorstandeditor.handler;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import me.petomka.armorstandeditor.Main;
import me.petomka.armorstandeditor.config.CommandStorage;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.InvalidConfigurationException;
import org.bukkit.entity.Player;

public class AttachedCommandsHandler {
    private static AttachedCommandsHandler instance;
    private final Main plugin;

    public static void init(Main plugin) {
        if (instance == null) {
            instance = new AttachedCommandsHandler(plugin);
        }
    }

    private AttachedCommandsHandler(Main plugin) {
        this.plugin = plugin;
    }

    public List<String> getAttachedCommands(UUID armorStand) {
        CommandStorage storage = this.plugin.getCommandStorage();
        return ImmutableList.copyOf((Collection)storage.getMappedCommands().getOrDefault(armorStand.toString(), Collections.emptyList()));
    }

    public void setAttachedCommands(UUID armorStand, List<String> commands) {
        if (commands.isEmpty()) {
            this.removeAll(armorStand);
            return;
        }
        CommandStorage storage = this.plugin.getCommandStorage();
        ImmutableList copy = ImmutableList.copyOf(commands);
        storage.getMappedCommands().put(armorStand.toString(), (List<String>)copy);
        try {
            storage.save();
        }
        catch (InvalidConfigurationException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error saving as-commands.yml", e);
        }
    }

    public void removeAll(UUID armorStand) {
        if (!this.hasCommands(armorStand)) {
            return;
        }
        CommandStorage storage = this.plugin.getCommandStorage();
        storage.getMappedCommands().remove(armorStand.toString());
        try {
            storage.save();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public boolean hasCommands(UUID armorStand) {
        return this.plugin.getCommandStorage().getMappedCommands().containsKey(armorStand.toString());
    }

    public void appendCommand(UUID armorStand, String commandLine) {
        ArrayList<String> commands = new ArrayList<String>(this.getAttachedCommands(armorStand));
        commands.add(commandLine);
        this.setAttachedCommands(armorStand, commands);
    }

    public boolean removeCommandByIndex(UUID armorStand, int index) {
        ArrayList<String> commands = new ArrayList<String>(this.getAttachedCommands(armorStand));
        if (index < 0 || index >= commands.size()) {
            return false;
        }
        commands.remove(index);
        this.setAttachedCommands(armorStand, commands);
        return true;
    }

    public boolean setCommandByIndex(UUID armorStand, int index, String command) {
        ArrayList<String> commands = new ArrayList<String>(this.getAttachedCommands(armorStand));
        if (index < 0 || index >= commands.size()) {
            return false;
        }
        commands.set(index, command);
        this.setAttachedCommands(armorStand, commands);
        return true;
    }

    public boolean insertCommandByIndex(UUID armorStand, int index, String command) {
        ArrayList<String> commands = new ArrayList<String>(this.getAttachedCommands(armorStand));
        if (index < 0 || index >= commands.size()) {
            return false;
        }
        commands.add(index, command);
        this.setAttachedCommands(armorStand, commands);
        return true;
    }

    public void performCommands(Player player, UUID armorStand) {
        List<String> commands = this.getAttachedCommands(armorStand);
        if (commands.isEmpty()) {
            return;
        }
        for (String command : commands) {
            String replaced = command.replace("@p", player.getName());
            player.performCommand(replaced);
        }
    }

    public static AttachedCommandsHandler getInstance() {
        return instance;
    }
}

