/*
 * Decompiled with CFR 0.152.
 */
package me.petomka.armorstandeditor.handler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.petomka.armorstandeditor.Main;
import me.petomka.armorstandeditor.handler.Accuracy;
import me.petomka.armorstandeditor.handler.ActionBarTask;
import me.petomka.armorstandeditor.handler.BossBarHandler;
import me.petomka.armorstandeditor.handler.Part;
import me.petomka.armorstandeditor.handler.ScoreboardHandler;
import me.petomka.armorstandeditor.inventory.InventoryMenu;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ArmorStandEditHandler {
    private static ArmorStandEditHandler instance;
    private ActionBarTask actionBarTask = new ActionBarTask();
    private Main plugin;
    private Set<UUID> proEditors = Sets.newHashSet();
    Map<UUID, Part> editingPlayers = Maps.newHashMap();
    Map<UUID, Set<ArmorStand>> editedArmorStands = Maps.newHashMap();
    Map<UUID, Accuracy> editingAccuracy = Maps.newHashMap();

    public ArmorStandEditHandler(Main main) {
        instance = this;
        this.plugin = main;
        this.actionBarTask.runTaskTimerAsynchronously((Plugin)main, 30L, 30L);
    }

    public boolean isEditingPlayer(@Nullable UUID player) {
        return this.editingPlayers.containsKey(player);
    }

    public boolean isProModeEditor(@Nullable UUID player) {
        if (!this.isEditingPlayer(player)) {
            return false;
        }
        return this.proEditors.contains(player);
    }

    public boolean toggleProMode(@Nonnull UUID player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        if (this.proEditors.add(player)) {
            return true;
        }
        this.proEditors.remove(player);
        return false;
    }

    @Nullable
    public Part getEditingPart(@Nonnull UUID player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        return this.editingPlayers.get(player);
    }

    public void addEditingPlayer(@Nonnull UUID player, @Nonnull Part part, @Nonnull ArmorStand armorStand) {
        Preconditions.checkNotNull((Object)armorStand, (Object)"armorStand");
        this.addEditingPlayer(player, part, Collections.singleton(armorStand));
    }

    public void addEditingPlayer(@Nonnull UUID player, @Nonnull Part part, @Nonnull Set<ArmorStand> armorStands) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Preconditions.checkNotNull((Object)((Object)part), (Object)"part");
        Preconditions.checkNotNull(armorStands, (Object)"armorStands");
        this.editingPlayers.put(player, part);
        Accuracy accuracy = this.editingAccuracy.get(player);
        String accuracyName = Main.getInstance().getDefaultConfig().getDefaultAccuracy();
        if (accuracy == null) {
            try {
                accuracy = Accuracy.valueOf(accuracyName);
            }
            catch (Exception e) {
                Main.getInstance().getLogger().log(Level.SEVERE, "Could not load accuracy from config default " + accuracyName, e);
                return;
            }
        }
        this.editingAccuracy.put(player, accuracy);
        this.editedArmorStands.put(player, armorStands);
        if (Main.getInstance().getDefaultConfig().isScoreboardEnabled() && !ScoreboardHandler.getInstance().registerPlayer(player)) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Error trying to register a player scoreboard!");
        }
        if (Main.getInstance().getDefaultConfig().isBossBarEnabled() && !BossBarHandler.getInstance().registerPlayer(player)) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Error trying to register a player boss bar!");
        }
        CompletableFuture.runAsync((Runnable)((Object)this.actionBarTask));
    }

    @Nonnull
    public Set<ArmorStand> getEditedArmorstands(@Nonnull UUID player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        if (this.editedArmorStands.get(player) == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Collection)this.editedArmorStands.get(player));
    }

    public boolean removeEditingPlayer(@Nonnull UUID player) {
        Player thePlayer;
        Preconditions.checkNotNull((Object)player, (Object)"player");
        BossBarHandler.getInstance().unregisterPlayer(player);
        ScoreboardHandler.getInstance().unregisterPlayer(player);
        this.actionBarTask.onEditingStop(player);
        this.editedArmorStands.remove(player);
        this.proEditors.remove(player);
        if (InventoryMenu.getOpenedInventories().get(player) != null && (thePlayer = Bukkit.getPlayer((UUID)player)) != null) {
            thePlayer.closeInventory();
        }
        return this.editingPlayers.remove(player) != null;
    }

    public void editNextPart(@Nonnull UUID player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Part part = this.getEditingPart(player);
        if (part == null) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Tried to update a non editing player's part with UUID " + player);
            return;
        }
        this.addEditingPlayer(player, part.nextPart(), this.getEditedArmorstands(player));
    }

    public void editPreviousPart(@Nonnull UUID player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Part part = this.getEditingPart(player);
        if (part == null) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Tried to update a non editing player's part with UUID " + player);
            return;
        }
        this.addEditingPlayer(player, part.previousPart(), this.getEditedArmorstands(player));
    }

    public void updateAccuracy(@Nonnull UUID player, boolean moreAccurate) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Accuracy oldAccuracy = this.editingAccuracy.get(player);
        Accuracy newAccuracy = moreAccurate ? oldAccuracy.moreAccurate() : oldAccuracy.lessAccurate();
        this.editingAccuracy.put(player, newAccuracy);
        if (Main.getInstance().getDefaultConfig().isBossBarEnabled() && !BossBarHandler.getInstance().updatePlayerBar(player)) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Could not update player boss bar");
        }
    }

    @Nullable
    public Accuracy getPlayerAccuracy(@Nonnull UUID player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Accuracy accuracy = this.editingAccuracy.get(player);
        if (accuracy == null) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Tried to query accuracy for non editing player with UUID " + player);
            return null;
        }
        return accuracy;
    }

    public Optional<ArmorStand> getSingleArmorstand(@Nonnull UUID player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        if (this.getEditedArmorstands(player).size() != 1) {
            return Optional.empty();
        }
        return this.getEditedArmorstands(player).stream().findAny();
    }

    @Nullable
    public UUID getArmorStandEditor(@Nonnull ArmorStand armorStand) {
        Preconditions.checkNotNull((Object)armorStand, (Object)"armorStand");
        return this.editedArmorStands.entrySet().stream().filter(entry -> ((Set)entry.getValue()).stream().anyMatch(armorStand::equals)).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    public void onAdjustmentMade(@Nonnull UUID player, double x, double y, double z) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        if (!this.isEditingPlayer(player)) {
            Main.getInstance().getLogger().log(Level.WARNING, "Tried to make armor stand adjustment for a player currently not editing");
            return;
        }
        Part part = this.getEditingPart(player);
        if (part == null) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Editing player with UUID " + player + " has no corresponding part.");
            return;
        }
        Set<ArmorStand> armorStands = this.editedArmorStands.get(player);
        if (armorStands == null || armorStands.isEmpty()) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Editing player with UUID " + player + " has no armor stands to adjust!");
            return;
        }
        Player thePlayer = Bukkit.getPlayer((UUID)player);
        if (thePlayer == null) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Unknown player with UUID " + player + " tried to make an adjustment");
            return;
        }
        if (part == Part.BODY && this.plugin.willBeTooFar(thePlayer, armorStands, new Vector(x, y, z))) {
            return;
        }
        if (part == Part.BODY && this.plugin.isInteractCancelled(thePlayer, armorStands, new Vector(x, y, z))) {
            return;
        }
        if (part == Part.BODY && this.plugin.getDefaultConfig().isDisableGravityOnYPositionChange() && y != 0.0) {
            if (!thePlayer.hasPermission(this.plugin.getDefaultConfig().getGravityPermission())) {
                thePlayer.sendMessage(Main.colorString(this.plugin.getMessages().getCannotChangeYAxis()));
                return;
            }
            armorStands.forEach(armorStand -> armorStand.setGravity(false));
        }
        armorStands.forEach(armorStand -> part.add((ArmorStand)armorStand, x, y, z));
        if (Main.getInstance().getDefaultConfig().isScoreboardEnabled() && !ScoreboardHandler.getInstance().updatePlayer(player)) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Could not update scoreboard for player with UUID " + player);
        }
    }

    public static ArmorStandEditHandler getInstance() {
        return instance;
    }
}

