/*
 * Decompiled with CFR 0.152.
 */
package me.petomka.armorstandeditor.handler;

import java.util.function.Supplier;
import me.petomka.armorstandeditor.Main;

public enum Accuracy {
    SMALLEST(0.01, Main.getInstance().getMessages()::getSmallestAdjustmentName),
    SMALLER(0.05, Main.getInstance().getMessages()::getSmallerAdjustmentName),
    SMALL(0.1, Main.getInstance().getMessages()::getSmallAdjustmentName),
    LARGE(0.3, Main.getInstance().getMessages()::getLargeAdjustmentName),
    LARGER(1.0, Main.getInstance().getMessages()::getLargerAdjustmentName),
    LARGEST(5.0, Main.getInstance().getMessages()::getLargestAdjustmentName);

    private final double adjustmentSize;
    private final Supplier<String> nameSupplier;

    public String getName() {
        return this.nameSupplier.get();
    }

    public Accuracy moreAccurate() {
        if (this == SMALLEST) {
            return SMALLEST;
        }
        return Accuracy.values()[(this.ordinal() - 1) % Accuracy.values().length];
    }

    public Accuracy lessAccurate() {
        if (this == LARGEST) {
            return LARGEST;
        }
        return Accuracy.values()[(this.ordinal() + 1) % Accuracy.values().length];
    }

    private Accuracy(double adjustmentSize, Supplier<String> nameSupplier) {
        this.adjustmentSize = adjustmentSize;
        this.nameSupplier = nameSupplier;
    }

    public double getAdjustmentSize() {
        return this.adjustmentSize;
    }
}

