/*
 * Decompiled with CFR 0.152.
 */
package me.petomka.armorstandeditor.config;

import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;
import me.petomka.armorstandeditor.Main;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.Comment;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.Config;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.InvalidConfigurationException;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.Path;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;

public class DefaultConfig
extends Config {
    private static String bossBarColors = Arrays.stream(BarColor.values()).map(Enum::name).collect(Collectors.joining(", "));
    private static String bossBarStyles = Arrays.stream(BarStyle.values()).map(Enum::name).collect(Collectors.joining(", "));
    @Comment(value="Permission required to start editing an armorstand")
    private String editPermission = "armorstandedit.use";
    @Comment(value="Permission required to start editing an armorstand with more options")
    private String proEditPermission = "armorstandedit.pro";
    @Comment(value="Permission required to perform a reload of config.yml and messages.yml")
    private String reloadPermission = "armorstandedit.reload";
    @Comment(value="Permission required to enable or disable editing for other players")
    private String toggleOthersPermission = "armorstandedit.toggle_others";
    @Comment(value="Permission required to place armorstands with saved NBT data")
    private String placeNBTArmorStandPermission = "armorstandedit.placecopy";
    @Comment(value="Permission required to create a copy of an armor stand in the gui")
    private String copyArmorStandPermission = "armorstandedit.copy";
    @Comment(value="Permission similar to the above, but does not allow for GUI copies, just for dropping copies when destroyed.")
    private String dropCopyArmorStandPermission = "armorstandedit.drop_copy";
    @Comment(value="Permission required to give a colored name to an armorstand with a nametag")
    private String colorNameTagsPermission = "armorstandedit.colornametag";
    @Comment(value="Permission required to rotate an armorstand by left/right clicking with leather")
    private String rotateLeatherPermission = "armorstandedit.rotateleather";
    @Comment(value="Permission required to break an armorstand that is currently being edited")
    private String breakEditedArmorStandPermission = "armorstandedit.breakedited";
    @Comment(value="Whether a user can toggle an armorstand's arms")
    private String showArmsPermission = "armorstandedit.flag.show_arms";
    @Comment(value="Whether a user can toggle an armorstand's baseplate")
    private String showBasePlatePermission = "armorstandedit.flag.show_base_plate";
    @Comment(value="Whether a user can make an armorstand small")
    private String smallArmorStandPermission = "armorstandedit.flag.small_armorstand";
    @Comment(value="Whether a user can make an armorstand invulnerable")
    private String invulnerableArmorStandPermission = "armorstandedit.flag.invulnerable";
    @Comment(value="Whether a user can toggle an armorstand's gravity")
    private String gravityPermission = "armorstandedit.flag.gravity";
    @Comment(value="Whether a user can toggle an armorstand's visibility")
    private String visibilityPermission = "armorstandedit.flag.visibility";
    @Comment(value="Whether a user can toggle an armorstand's custom name")
    private String customNamePermission = "armorstandedit.flag.custom_name";
    @Comment(value="Whether a user can toggle an armorstand's glowing effect, also affects pro-mode!")
    private String glowingPermission = "armorstandedit.flag.glowing";
    @Comment(value="Whether a user can directly set an armorstand's equipment via gui - does not affect normal equipping.")
    private String setEquipPermission = "armorstandedit.set_equip";
    @Comment(value="Whether a user can modify an armor stand's equipment locks")
    private String setEquipLocksPermission = "armorstandedit.set_equip_locks";
    @Comment(value="Whether a user can modify the commands attached to an armor stand.")
    private String attachCommandsPermission = "armorstandedit.attach_commands";
    @Comment(value="Whether custom armor stands should drop a copy of themselves when they are destroyed")
    private boolean dropCopyOfDestroyedArmorStand = true;
    @Comment(value="Angle to rotate armor stand in when clicked with leather")
    private int rotateLeatherDegrees = 45;
    @Comment(value="Display additional information about current armorstand in sidebar scoreboard?")
    private boolean scoreboardEnabled = true;
    @Comment(value="Display information about current editing precision in boss bar?")
    private boolean bossBarEnabled = true;
    @Comment(value="Provide audio feedback for actions")
    private boolean playSounds = true;
    @Comment(value="Whether an armor stands gravity should automatically be disabled on Y axis change. If true, users\n# without the permission to disable the gravity will not be able to move the armor stand on the y axis.")
    private boolean disableGravityOnYPositionChange = true;
    @Comment(value="The maximum distance an armorstand will be able to be moved away from the editor")
    private float maximumEditDistance = 5.0f;
    @Path(value="bossBarColor")
    private String bossBarColor = BarColor.RED.name();
    @Path(value="bossBarStyle")
    private String bossBarStyle = BarStyle.SEGMENTED_6.name();
    @Comment(value="Default accuracy to begin editing with, possible values are: SMALLEST, SMALLER, SMALL, LARGE, LARGER, LARGEST")
    private String defaultAccuracy = "LARGE";

    public DefaultConfig(Main main) throws InvalidConfigurationException {
        this.CONFIG_HEADER = new String[]{"Default configuration"};
        this.CONFIG_FILE = new File(main.getDataFolder(), "config.yml");
        this.addComment("bossBarColor", "What color the bar should have, available colors: " + bossBarColors);
        this.addComment("bossBarStyle", "What style the bar should have, available styles: " + bossBarStyles);
        this.init();
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public String getProEditPermission() {
        return this.proEditPermission;
    }

    public String getReloadPermission() {
        return this.reloadPermission;
    }

    public String getToggleOthersPermission() {
        return this.toggleOthersPermission;
    }

    public String getPlaceNBTArmorStandPermission() {
        return this.placeNBTArmorStandPermission;
    }

    public String getCopyArmorStandPermission() {
        return this.copyArmorStandPermission;
    }

    public String getDropCopyArmorStandPermission() {
        return this.dropCopyArmorStandPermission;
    }

    public String getColorNameTagsPermission() {
        return this.colorNameTagsPermission;
    }

    public String getRotateLeatherPermission() {
        return this.rotateLeatherPermission;
    }

    public String getBreakEditedArmorStandPermission() {
        return this.breakEditedArmorStandPermission;
    }

    public String getShowArmsPermission() {
        return this.showArmsPermission;
    }

    public String getShowBasePlatePermission() {
        return this.showBasePlatePermission;
    }

    public String getSmallArmorStandPermission() {
        return this.smallArmorStandPermission;
    }

    public String getInvulnerableArmorStandPermission() {
        return this.invulnerableArmorStandPermission;
    }

    public String getGravityPermission() {
        return this.gravityPermission;
    }

    public String getVisibilityPermission() {
        return this.visibilityPermission;
    }

    public String getCustomNamePermission() {
        return this.customNamePermission;
    }

    public String getGlowingPermission() {
        return this.glowingPermission;
    }

    public String getSetEquipPermission() {
        return this.setEquipPermission;
    }

    public String getSetEquipLocksPermission() {
        return this.setEquipLocksPermission;
    }

    public String getAttachCommandsPermission() {
        return this.attachCommandsPermission;
    }

    public boolean isDropCopyOfDestroyedArmorStand() {
        return this.dropCopyOfDestroyedArmorStand;
    }

    public int getRotateLeatherDegrees() {
        return this.rotateLeatherDegrees;
    }

    public boolean isScoreboardEnabled() {
        return this.scoreboardEnabled;
    }

    public boolean isBossBarEnabled() {
        return this.bossBarEnabled;
    }

    public boolean isPlaySounds() {
        return this.playSounds;
    }

    public boolean isDisableGravityOnYPositionChange() {
        return this.disableGravityOnYPositionChange;
    }

    public float getMaximumEditDistance() {
        return this.maximumEditDistance;
    }

    public String getBossBarColor() {
        return this.bossBarColor;
    }

    public String getBossBarStyle() {
        return this.bossBarStyle;
    }

    public String getDefaultAccuracy() {
        return this.defaultAccuracy;
    }

    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    public void setProEditPermission(String proEditPermission) {
        this.proEditPermission = proEditPermission;
    }

    public void setReloadPermission(String reloadPermission) {
        this.reloadPermission = reloadPermission;
    }

    public void setToggleOthersPermission(String toggleOthersPermission) {
        this.toggleOthersPermission = toggleOthersPermission;
    }

    public void setPlaceNBTArmorStandPermission(String placeNBTArmorStandPermission) {
        this.placeNBTArmorStandPermission = placeNBTArmorStandPermission;
    }

    public void setCopyArmorStandPermission(String copyArmorStandPermission) {
        this.copyArmorStandPermission = copyArmorStandPermission;
    }

    public void setDropCopyArmorStandPermission(String dropCopyArmorStandPermission) {
        this.dropCopyArmorStandPermission = dropCopyArmorStandPermission;
    }

    public void setColorNameTagsPermission(String colorNameTagsPermission) {
        this.colorNameTagsPermission = colorNameTagsPermission;
    }

    public void setRotateLeatherPermission(String rotateLeatherPermission) {
        this.rotateLeatherPermission = rotateLeatherPermission;
    }

    public void setBreakEditedArmorStandPermission(String breakEditedArmorStandPermission) {
        this.breakEditedArmorStandPermission = breakEditedArmorStandPermission;
    }

    public void setShowArmsPermission(String showArmsPermission) {
        this.showArmsPermission = showArmsPermission;
    }

    public void setShowBasePlatePermission(String showBasePlatePermission) {
        this.showBasePlatePermission = showBasePlatePermission;
    }

    public void setSmallArmorStandPermission(String smallArmorStandPermission) {
        this.smallArmorStandPermission = smallArmorStandPermission;
    }

    public void setInvulnerableArmorStandPermission(String invulnerableArmorStandPermission) {
        this.invulnerableArmorStandPermission = invulnerableArmorStandPermission;
    }

    public void setGravityPermission(String gravityPermission) {
        this.gravityPermission = gravityPermission;
    }

    public void setVisibilityPermission(String visibilityPermission) {
        this.visibilityPermission = visibilityPermission;
    }

    public void setCustomNamePermission(String customNamePermission) {
        this.customNamePermission = customNamePermission;
    }

    public void setGlowingPermission(String glowingPermission) {
        this.glowingPermission = glowingPermission;
    }

    public void setSetEquipPermission(String setEquipPermission) {
        this.setEquipPermission = setEquipPermission;
    }

    public void setSetEquipLocksPermission(String setEquipLocksPermission) {
        this.setEquipLocksPermission = setEquipLocksPermission;
    }

    public void setAttachCommandsPermission(String attachCommandsPermission) {
        this.attachCommandsPermission = attachCommandsPermission;
    }

    public void setDropCopyOfDestroyedArmorStand(boolean dropCopyOfDestroyedArmorStand) {
        this.dropCopyOfDestroyedArmorStand = dropCopyOfDestroyedArmorStand;
    }

    public void setRotateLeatherDegrees(int rotateLeatherDegrees) {
        this.rotateLeatherDegrees = rotateLeatherDegrees;
    }

    public void setScoreboardEnabled(boolean scoreboardEnabled) {
        this.scoreboardEnabled = scoreboardEnabled;
    }

    public void setBossBarEnabled(boolean bossBarEnabled) {
        this.bossBarEnabled = bossBarEnabled;
    }

    public void setPlaySounds(boolean playSounds) {
        this.playSounds = playSounds;
    }

    public void setDisableGravityOnYPositionChange(boolean disableGravityOnYPositionChange) {
        this.disableGravityOnYPositionChange = disableGravityOnYPositionChange;
    }

    public void setMaximumEditDistance(float maximumEditDistance) {
        this.maximumEditDistance = maximumEditDistance;
    }

    public void setBossBarColor(String bossBarColor) {
        this.bossBarColor = bossBarColor;
    }

    public void setBossBarStyle(String bossBarStyle) {
        this.bossBarStyle = bossBarStyle;
    }

    public void setDefaultAccuracy(String defaultAccuracy) {
        this.defaultAccuracy = defaultAccuracy;
    }
}

