/*
 * Decompiled with CFR 0.152.
 */
package me.petomka.armorstandeditor;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.petomka.armorstandeditor.command.ArmorStandEditorCommand;
import me.petomka.armorstandeditor.config.CommandStorage;
import me.petomka.armorstandeditor.config.DefaultConfig;
import me.petomka.armorstandeditor.config.DisabledPlayersStorage;
import me.petomka.armorstandeditor.config.Messages;
import me.petomka.armorstandeditor.handler.ArmorStandEditHandler;
import me.petomka.armorstandeditor.handler.AttachedCommandsHandler;
import me.petomka.armorstandeditor.inventory.InventoryMenu;
import me.petomka.armorstandeditor.inventory.MenuItem;
import me.petomka.armorstandeditor.listener.ArmorStandEditListener;
import me.petomka.armorstandeditor.listener.AttachedCommandsListener;
import me.petomka.armorstandeditor.listener.PlayerListener;
import me.petomka.armorstandeditor.net.cubespace.Yamler.Config.InvalidConfigurationException;
import me.petomka.armorstandeditor.util.EntityLocationProxy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class Main
extends JavaPlugin {
    public static final int PRO_MODE_SLOT = 4;
    private static Main instance;
    private static final Set<Event> eventsToIgnore;
    private Messages messages;
    private DefaultConfig defaultConfig;
    private DisabledPlayersStorage disabledPlayersStorage;
    private CommandStorage commandStorage;

    public void onEnable() {
        instance = this;
        try {
            this.defaultConfig = new DefaultConfig(this);
        }
        catch (InvalidConfigurationException e) {
            this.getLogger().log(Level.SEVERE, "Your defaultConfig.yml was wrong", e);
            this.panic();
            return;
        }
        try {
            this.messages = new Messages(this);
        }
        catch (InvalidConfigurationException e) {
            this.getLogger().log(Level.SEVERE, "Your messages.yml was wrong", e);
            this.panic();
            return;
        }
        try {
            this.disabledPlayersStorage = new DisabledPlayersStorage(this);
        }
        catch (InvalidConfigurationException e) {
            this.getLogger().log(Level.SEVERE, "Your disabled_players.yml is invalid.", e);
            this.panic();
            return;
        }
        try {
            this.commandStorage = new CommandStorage(this);
        }
        catch (InvalidConfigurationException e) {
            this.getLogger().log(Level.SEVERE, "Your as-commands.yml is invalid.", e);
            this.panic();
            return;
        }
        AttachedCommandsHandler.init(this);
        new ArmorStandEditHandler(this);
        new AttachedCommandsListener(this);
        PluginManager manager = Bukkit.getPluginManager();
        manager.registerEvents((Listener)new ArmorStandEditListener(this), (Plugin)this);
        manager.registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.getCommand("armorstandeditor").setExecutor((CommandExecutor)new ArmorStandEditorCommand());
        InventoryMenu.reloadItemNames();
        MenuItem.reloadMenuItems();
    }

    public void onDisable() {
        this.messages = null;
        this.defaultConfig = null;
        if (this.disabledPlayersStorage != null) {
            try {
                this.disabledPlayersStorage.save();
            }
            catch (InvalidConfigurationException e) {
                this.getLogger().log(Level.SEVERE, "Error saving disabled_players.yml!", e);
            }
        }
        this.disabledPlayersStorage = null;
        instance = null;
    }

    private void panic() {
        this.getLogger().log(Level.SEVERE, "Disabling plugin due to startup error.");
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    public boolean isInteractCancelled(Player player, Collection<ArmorStand> entities, Vector delta) {
        double x = delta.getX();
        double y = delta.getY();
        double z = delta.getZ();
        boolean cancelled = entities.stream().map(as -> {
            EntityLocationProxy proxy = new EntityLocationProxy((Entity)as, as.getLocation().add(x, y, z));
            PlayerInteractEntityEvent event = new PlayerInteractEntityEvent(player, (Entity)proxy);
            Main.getEventsToIgnore().add((Event)event);
            Bukkit.getPluginManager().callEvent((Event)event);
            return event;
        }).anyMatch(Cancellable::isCancelled);
        Main.getEventsToIgnore().clear();
        return cancelled;
    }

    public boolean willBeTooFar(Player player, Collection<ArmorStand> entities, Vector delta) {
        Vector playerVector = player.getLocation().toVector();
        double maxDist = this.defaultConfig.getMaximumEditDistance();
        double maxDistSquared = maxDist * maxDist;
        return entities.stream().map(armorStand -> armorStand.getLocation().toVector()).anyMatch(vector -> {
            double preDist = vector.distanceSquared(playerVector);
            double postDist = vector.add(delta).distanceSquared(playerVector);
            return postDist > preDist && postDist > maxDistSquared;
        });
    }

    public static String colorString(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static List<String> copySubstringMatches(Collection<String> strings, String startsWith) {
        return strings.stream().filter(s -> s.startsWith(startsWith)).collect(Collectors.toList());
    }

    public static <K, V> Map<K, V> mapOf(Supplier<Map> mapSupplier, Object ... objects) {
        Preconditions.checkNotNull(mapSupplier, (Object)"mapSupplier");
        Preconditions.checkNotNull((Object)objects, (Object)"objects");
        Preconditions.checkArgument((objects.length % 2 == 0 ? 1 : 0) != 0, (Object)"objects must be of even size");
        Map result = mapSupplier.get();
        for (int a = 0; a < objects.length; a += 2) {
            result.put(objects[a], objects[a + 1]);
        }
        return result;
    }

    public static int normalizeYaw(float yaw) {
        return Math.floorMod((int)yaw, 360);
    }

    public static String formatDouble(double value) {
        return String.format("%.2f%n", value).trim();
    }

    public static Main getInstance() {
        return instance;
    }

    public static Set<Event> getEventsToIgnore() {
        return eventsToIgnore;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public DisabledPlayersStorage getDisabledPlayersStorage() {
        return this.disabledPlayersStorage;
    }

    public CommandStorage getCommandStorage() {
        return this.commandStorage;
    }

    static {
        eventsToIgnore = new HashSet<Event>();
    }
}

