/*
 * Decompiled with CFR 0.152.
 */
package net.islandearth.anvillogin.listeners;

import com.github.games647.fastlogin.bukkit.FastLoginBukkit;
import com.github.games647.fastlogin.core.PremiumStatus;
import com.google.common.base.Enums;
import fr.xephi.authme.api.v3.AuthMeApi;
import java.util.ArrayList;
import net.islandearth.anvillogin.AnvilLogin;
import net.islandearth.anvillogin.libs.anvilgui.AnvilGUI;
import net.islandearth.anvillogin.translation.Translations;
import net.islandearth.anvillogin.util.Colors;
import net.islandearth.anvillogin.util.ItemStackBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    private final AnvilLogin plugin;

    public PlayerListener(AnvilLogin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent pje) {
        Player myPlayer = pje.getPlayer();
        if (!myPlayer.hasPermission("AnvilLogin.bypass") && !this.plugin.getLoggedIn().contains(myPlayer.getUniqueId())) {
            Object premiumStatus;
            FastLoginBukkit fastLogin;
            if (this.plugin.isAuthme() && (AuthMeApi.getInstance().isAuthenticated(myPlayer) || AuthMeApi.getInstance().isUnrestricted(myPlayer))) {
                return;
            }
            if (this.plugin.getConfig().getBoolean("fastlogin") && Bukkit.getPluginManager().getPlugin("FastLogin") != null && (fastLogin = (FastLoginBukkit)Bukkit.getPluginManager().getPlugin("FastLogin")) != null && (premiumStatus = fastLogin.getStatus(myPlayer.getUniqueId())) == PremiumStatus.PREMIUM) {
                if (this.plugin.debug()) {
                    this.plugin.getLogger().info("Skipping player " + myPlayer.getName() + " because they are premium.");
                }
                return;
            }
            this.plugin.getNotLoggedIn().add(myPlayer.getUniqueId());
            ArrayList<String> colouredLeftLore = new ArrayList<String>();
            for (Object leftLore : this.plugin.getConfig().getStringList("left_slot.lore")) {
                colouredLeftLore.add(Colors.color((String)leftLore));
            }
            ArrayList<String> colouredRightLore = new ArrayList<String>();
            for (String rightLore : this.plugin.getConfig().getStringList("right_slot.lore")) {
                colouredRightLore.add(Colors.color(rightLore));
            }
            ItemStack leftItem = ItemStackBuilder.of((Material)Enums.getIfPresent(Material.class, (String)this.plugin.getConfig().getString("left_slot.type", "ANVIL")).or((Object)Material.ANVIL)).addFlags(ItemFlag.HIDE_ATTRIBUTES).withLore(colouredLeftLore).withModel(this.plugin.getConfig().getInt("left_slot.model")).build();
            Material rightType = (Material)Enums.getIfPresent(Material.class, (String)this.plugin.getConfig().getString("right_slot.type", "AIR")).or((Object)Material.AIR);
            ItemStack rightItem = rightType == Material.AIR ? new ItemStack(Material.AIR) : ItemStackBuilder.of(rightType).addFlags(ItemFlag.HIDE_ATTRIBUTES).withLore(colouredRightLore).withName(Colors.color(this.plugin.getConfig().getString("right_slot.name", ""))).withModel(this.plugin.getConfig().getInt("right_slot.model")).build();
            AnvilGUI.Builder anvilGUI = new AnvilGUI.Builder().onComplete((player, text) -> {
                if (this.plugin.isAuthme() && this.plugin.getConfig().getBoolean("register") && !AuthMeApi.getInstance().isRegistered(player.getName())) {
                    AuthMeApi.getInstance().forceRegister(player, text, true);
                    this.plugin.getLoggedIn().add(player.getUniqueId());
                    this.plugin.getNotLoggedIn().remove(player.getUniqueId());
                    if (this.plugin.getConfig().getBoolean("login_messages")) {
                        Translations.LOGGED_IN.send((Player)player, new Object[0]);
                    }
                    return AnvilGUI.Response.close();
                }
                if (text.equalsIgnoreCase(this.plugin.getConfig().getString("Password")) || this.plugin.isAuthme() && AuthMeApi.getInstance().checkPassword(player.getName(), text)) {
                    this.plugin.getLoggedIn().add(player.getUniqueId());
                    this.plugin.getNotLoggedIn().remove(player.getUniqueId());
                    if (this.plugin.getConfig().getBoolean("login_messages")) {
                        Translations.LOGGED_IN.send((Player)player, new Object[0]);
                    }
                    if (this.plugin.isAuthme()) {
                        AuthMeApi.getInstance().forceLogin(player);
                    }
                    player.setLevel(player.getLevel());
                    return AnvilGUI.Response.close();
                }
                return AnvilGUI.Response.text(Translations.GUI_WRONG.get(myPlayer, new Object[0]).get(0));
            }).preventClose().text(Translations.GUI_TEXT.get(myPlayer, new Object[0]).get(0)).itemLeft(leftItem).itemRight(rightItem).title(Translations.GUI_TITLE.get(myPlayer, new Object[0]).get(0)).plugin((Plugin)this.plugin);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> anvilGUI.open(myPlayer), 20L);
            if (this.plugin.getConfig().getBoolean("Timeout")) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (!this.plugin.getLoggedIn().contains(myPlayer.getUniqueId())) {
                        myPlayer.kickPlayer(Translations.KICKED.get(myPlayer, new Object[0]).get(0));
                    }
                }, this.plugin.getConfig().getLong("Time"));
            }
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getNotLoggedIn().contains(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        Player player = (Player)event.getView().getPlayer();
        if (this.plugin.getNotLoggedIn().contains(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.plugin.getNotLoggedIn().contains(player.getUniqueId())) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent pqe) {
        Player player = pqe.getPlayer();
        this.plugin.getLoggedIn().remove(player.getUniqueId());
        this.plugin.getNotLoggedIn().remove(player.getUniqueId());
    }
}

