/*
 * Decompiled with CFR 0.152.
 */
package net.axay.antidisconnectspam.functionality;

import java.util.ArrayList;
import java.util.HashMap;
import net.axay.antidisconnectspam.main.Manager;
import net.axay.antidisconnectspam.utils.ItemBuilder;
import net.axay.antidisconnectspam.utils.UniversalVersionManager;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class SettingsGUI
implements Listener {
    private Inventory settingsInv;
    private ItemStack activated;
    private ItemStack deactivated;
    private ItemStack neutralAction;
    private HashMap<Integer, SettingCallback> settingCallbacks;
    private HashMap<Integer, SettingType> settingTypes;

    public SettingsGUI(String name, InventoryType inventoryType) {
        this(name, inventoryType, 0);
    }

    public SettingsGUI(String name, int size) {
        this(name, null, size);
    }

    private SettingsGUI(String name, InventoryType inventoryType, int size) {
        this.settingsInv = inventoryType != null ? Bukkit.getServer().createInventory(null, inventoryType, name) : Bukkit.getServer().createInventory(null, size, name);
        Material woolMaterial = UniversalVersionManager.getWoolMaterial();
        this.activated = ItemBuilder.buildItem(woolMaterial, 1, "\u00a7aACTIVE", null, null);
        UniversalVersionManager.applyWoolColor(this.activated, DyeColor.GREEN);
        this.deactivated = ItemBuilder.buildItem(woolMaterial, 1, "\u00a7cINACTIVE", null, null);
        UniversalVersionManager.applyWoolColor(this.deactivated, DyeColor.RED);
        this.neutralAction = ItemBuilder.buildItem(woolMaterial, 1, "\u00a7fSETTING", null, null);
        UniversalVersionManager.applyWoolColor(this.neutralAction, DyeColor.WHITE);
        this.settingCallbacks = new HashMap();
        this.settingTypes = new HashMap();
        Manager.getPlugin().getPluginManager().registerEvents((Listener)this, (Plugin)Manager.getPlugin());
    }

    public void setSetting(int location, SettingType settingType, String name, ArrayList<String> settingLore, SettingCallback clickCallback) {
        ItemStack itemStack;
        switch (settingType) {
            case BOOLEAN_ACTIVE: {
                itemStack = this.activated.clone();
                break;
            }
            case BOOLEAN_INACTIVE: {
                itemStack = this.deactivated.clone();
                break;
            }
            default: {
                itemStack = this.neutralAction.clone();
            }
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        settingLore.add(0, "\u00a7d\u25b6 \u00a77" + name);
        itemMeta.setLore(settingLore);
        itemStack.setItemMeta(itemMeta);
        this.settingsInv.setItem(location, itemStack);
        this.settingTypes.put(location, settingType);
        this.settingCallbacks.put(location, clickCallback);
    }

    public void toggleSetting(int location, SettingType toggleTo) {
        this.settingTypes.put(location, toggleTo);
        ItemStack toggleItem = this.settingsInv.getItem(location);
        ItemMeta toggleMeta = toggleItem.getItemMeta();
        if (toggleTo.equals((Object)SettingType.BOOLEAN_ACTIVE)) {
            UniversalVersionManager.applyWoolColor(toggleItem, DyeColor.GREEN);
            toggleMeta.setDisplayName(this.activated.getItemMeta().getDisplayName());
        } else {
            UniversalVersionManager.applyWoolColor(toggleItem, DyeColor.RED);
            toggleMeta.setDisplayName(this.deactivated.getItemMeta().getDisplayName());
        }
        toggleItem.setItemMeta(toggleMeta);
    }

    public void removeSetting(int location) {
        this.settingsInv.setItem(location, null);
        this.settingCallbacks.remove(location);
        this.settingTypes.remove(location);
    }

    public void open(Player p) {
        p.openInventory(this.settingsInv);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        block8: {
            Player p;
            block10: {
                SettingCallback settingCallback;
                block9: {
                    if (!e.getInventory().equals(this.settingsInv)) break block8;
                    e.setCancelled(true);
                    SettingType settingType = this.settingTypes.get(e.getSlot());
                    settingCallback = this.settingCallbacks.get(e.getSlot());
                    p = (Player)e.getWhoClicked();
                    if (settingCallback == null) break block8;
                    if (settingType == null) break block9;
                    switch (settingType) {
                        case BOOLEAN_ACTIVE: {
                            if (settingCallback.runToggle(p, false)) {
                                this.toggleSetting(e.getSlot(), SettingType.BOOLEAN_INACTIVE);
                                break;
                            }
                            break block10;
                        }
                        case BOOLEAN_INACTIVE: {
                            if (settingCallback.runToggle(p, true)) {
                                this.toggleSetting(e.getSlot(), SettingType.BOOLEAN_ACTIVE);
                                break;
                            }
                            break block10;
                        }
                        default: {
                            settingCallback.run(p);
                            break;
                        }
                    }
                    break block10;
                }
                settingCallback.run(p);
            }
            try {
                p.playSound(p.getLocation(), UniversalVersionManager.getBasicNoteblockSound(), 1.0f, 1.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Inventory getSettingsInv() {
        return this.settingsInv;
    }

    public static interface SettingCallback {
        default public void run(Player p) {
        }

        default public boolean runToggle(Player p, boolean newstate) {
            return false;
        }
    }

    public static enum SettingType {
        BOOLEAN_ACTIVE,
        BOOLEAN_INACTIVE,
        NEUTRAL;

    }
}

