/*
 * Decompiled with CFR 0.152.
 */
package net.axay.antidisconnectspam.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigManager {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getConfig(String path, Class<?> configClass) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        Gson gson = new Gson();
        try (FileReader reader = new FileReader(path);){
            Object object = gson.fromJson((Reader)reader, configClass);
            return object;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void createNewConfig(String path, Object defaultConfig) {
        File file = new File(path);
        if (!file.exists()) {
            new File(file.getParent()).mkdir();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (defaultConfig != null) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (FileWriter writer = new FileWriter(file);){
                gson.toJson(defaultConfig, (Appendable)writer);
            }
            catch (IOException | StackOverflowError e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveConfig(String path, Object config) {
        File file = new File(path);
        if (!file.exists()) {
            ConfigManager.createNewConfig(path, config);
        } else if (config != null) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (FileWriter writer = new FileWriter(file);){
                gson.toJson(config, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

