/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.util;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.regex.Matcher;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.enums.PatternType;
import me.jasperjh.animatedscoreboard.enums.ServerVersion;
import net.md_5.bungee.api.ChatColor;

public class Strings {
    public static String spaces(int number) {
        char[] text = new char[number];
        Arrays.fill(text, ' ');
        return new String(text);
    }

    public static boolean isColor(ChatColor chatColor) {
        return !Strings.isFormat(chatColor);
    }

    public static boolean isFormat(ChatColor chatColor) {
        if (chatColor.equals((Object)ChatColor.BOLD)) {
            return true;
        }
        if (chatColor.equals((Object)ChatColor.ITALIC)) {
            return true;
        }
        if (chatColor.equals((Object)ChatColor.STRIKETHROUGH)) {
            return true;
        }
        if (chatColor.equals((Object)ChatColor.UNDERLINE)) {
            return true;
        }
        return chatColor.equals((Object)ChatColor.MAGIC);
    }

    public static String parseColors(String text) {
        if (!ServerVersion.current().isNewerThanOrEqualTo(ServerVersion.v1_16)) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        }
        Matcher matcher = PatternType.HEX_COLOR.getMatcher(ChatColor.translateAlternateColorCodes((char)'&', (String)text));
        StringBuffer buf = new StringBuffer(text.length());
        while (matcher.find()) {
            String colorFormat = matcher.group(1);
            ChatColor color = null;
            try {
                color = ChatColor.of((String)colorFormat);
            }
            catch (IllegalArgumentException e) {
                AnimatedScoreboard.getInstance().log(Level.SEVERE, "Cannot resolve colors for line {0} and color {1}!", text, colorFormat);
            }
            matcher.appendReplacement(buf, color == null ? colorFormat : color.toString());
        }
        return matcher.appendTail(buf).toString();
    }
}

