/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import me.jasperjh.animatedscoreboard.enums.ServerVersion;
import me.jasperjh.animatedscoreboard.objects.ScoreboardPlayer;
import org.bukkit.entity.Player;

public class ScoreboardReflection {
    private final Object unsafe;
    private final Method allocateInstance;
    private final Field playerConnection;
    private final Method getHandle;
    private final Method sendPacket;
    private final EmptyConstructor packetPlayOutScoreboardObjectiveConstructor;
    private final Field packetPlayOutScoreboardObjectiveName;
    private final Field packetPlayOutScoreboardObjectiveDisplayName;
    private final Field packetPlayOutScoreboardObjectiveHealthDisplay;
    private final Field packetPlayOutScoreboardObjectiveMode;
    private final EmptyConstructor packetPlayOutScoreboardDisplayObjectiveConstructor;
    private final Field packetPlayOutScoreboardDisplayObjectivePosition;
    private final Field packetPlayOutScoreboardDisplayObjectiveName;
    private final EmptyConstructor packetPlayOutScoreboardScoreConstructor;
    private final Field packetPlayOutScoreboardScoreName;
    private final Field packetPlayOutScoreboardScoreObjectiveName;
    private final Field packetPlayOutScoreboardScoreValue;
    private final Field packetPlayOutScoreboardScoreAction;
    private final EmptyConstructor packetPlayOutScoreboardTeamConstructor;
    private final Field packetPlayOutScoreboardTeamName;
    private final Field packetPlayOutScoreboardTeamDisplayName;
    private final Field packetPlayOutScoreboardTeamPrefix;
    private final Field packetPlayOutScoreboardTeamSuffix;
    private final Field packetPlayOutScoreboardTeamColor;
    private final Field packetPlayOutScoreboardTeamNames;
    private final Field packetPlayOutScoreboardTeamMode;
    private final Field packetPlayOutScoreboardTeamData;
    private final EmptyConstructor scoreboardTeamDataConstructor;
    private final Field scoreboardTeamDataDisplayName;
    private final Field scoreboardTeamDataPrefix;
    private final Field scoreboardTeamDataSuffix;
    private final Field scoreboardTeamDataNametagVisibility;
    private final Field scoreboardTeamDataCollisionRule;
    private final Field scoreboardTeamDataColor;
    private final Object integerHealthDisplay;
    private final Object scoreboardActionChange;
    private final Object scoreboardActionRemove;
    private final Object chatColorWhite;
    private final Method fromString;
    private final boolean versionSpecificNMS;
    private final String basePath;

    public ScoreboardReflection() throws ClassNotFoundException, NoSuchFieldException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException {
        ServerVersion current = ServerVersion.current();
        Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
        Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
        unsafeField.setAccessible(true);
        this.unsafe = unsafeField.get(null);
        this.allocateInstance = this.unsafe.getClass().getMethod("allocateInstance", Class.class);
        this.versionSpecificNMS = !current.isNewerThanOrEqualTo(ServerVersion.v1_17);
        this.basePath = this.versionSpecificNMS ? "net.minecraft.server." + ServerVersion.current().getExactVersion() + "." : "net.minecraft.";
        Class<?> craftPlayer = this.getCraftBukkitClass("entity.CraftPlayer");
        this.getHandle = craftPlayer.getMethod("getHandle", new Class[0]);
        Class<?> entityPlayer = this.getNMSClass("server.level", "EntityPlayer");
        Class<?> playerConnectionClass = this.getNMSClass("server.network", "PlayerConnection");
        Class<?> packetClass = this.getNMSClass("network.protocol", "Packet");
        this.playerConnection = this.getFieldOfType(entityPlayer, playerConnectionClass);
        this.sendPacket = this.findMethod(playerConnectionClass, packetClass);
        Class<?> packetPlayOutScoreboardObjective = this.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardObjective");
        this.packetPlayOutScoreboardObjectiveConstructor = this.getEmptyConstructor(packetPlayOutScoreboardObjective);
        this.packetPlayOutScoreboardObjectiveName = this.getField(packetPlayOutScoreboardObjective, current.getScoreboardObjectiveNameField());
        this.packetPlayOutScoreboardObjectiveDisplayName = this.getField(packetPlayOutScoreboardObjective, current.getScoreboardObjectiveDisplayNameField());
        this.packetPlayOutScoreboardObjectiveHealthDisplay = this.getField(packetPlayOutScoreboardObjective, current.getScoreboardObjectiveHealthDisplayField());
        this.packetPlayOutScoreboardObjectiveMode = this.getField(packetPlayOutScoreboardObjective, current.getScoreboardObjectiveModeField());
        Class<?> packetPlayOutScoreboardDisplayObjective = this.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardDisplayObjective");
        this.packetPlayOutScoreboardDisplayObjectiveConstructor = this.getEmptyConstructor(packetPlayOutScoreboardDisplayObjective);
        this.packetPlayOutScoreboardDisplayObjectivePosition = this.getField(packetPlayOutScoreboardDisplayObjective, "a");
        this.packetPlayOutScoreboardDisplayObjectiveName = this.getField(packetPlayOutScoreboardDisplayObjective, "b");
        Class<?> packetPlayOutScoreboardScore = this.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardScore");
        this.packetPlayOutScoreboardScoreConstructor = this.getEmptyConstructor(packetPlayOutScoreboardScore);
        this.packetPlayOutScoreboardScoreName = this.getField(packetPlayOutScoreboardScore, "a");
        this.packetPlayOutScoreboardScoreObjectiveName = this.getField(packetPlayOutScoreboardScore, "b");
        this.packetPlayOutScoreboardScoreValue = this.getField(packetPlayOutScoreboardScore, "c");
        this.packetPlayOutScoreboardScoreAction = this.getField(packetPlayOutScoreboardScore, "d");
        Class<?> packetPlayOutScoreboardTeam = this.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardTeam");
        this.packetPlayOutScoreboardTeamConstructor = this.getEmptyConstructor(packetPlayOutScoreboardTeam);
        this.packetPlayOutScoreboardTeamName = this.getField(packetPlayOutScoreboardTeam, current.getScoreboardTeamNameField());
        this.packetPlayOutScoreboardTeamDisplayName = this.getField(packetPlayOutScoreboardTeam, current.getScoreboardTeamDisplayNameField());
        this.packetPlayOutScoreboardTeamPrefix = this.getField(packetPlayOutScoreboardTeam, current.getScoreboardTeamPrefixField());
        this.packetPlayOutScoreboardTeamSuffix = this.getField(packetPlayOutScoreboardTeam, current.getScoreboardTeamSuffixField());
        this.packetPlayOutScoreboardTeamColor = this.getField(packetPlayOutScoreboardTeam, current.getScoreboardColorField());
        this.packetPlayOutScoreboardTeamNames = this.getField(packetPlayOutScoreboardTeam, current.getScoreboardNamesField());
        this.packetPlayOutScoreboardTeamMode = this.getField(packetPlayOutScoreboardTeam, current.getScoreboardModeField());
        this.packetPlayOutScoreboardTeamData = this.getField(packetPlayOutScoreboardTeam, current.getScoreboardTeamDataField());
        if (!this.versionSpecificNMS) {
            Class<?> teamData = this.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardTeam$b");
            this.scoreboardTeamDataConstructor = this.getEmptyConstructor(teamData);
            this.scoreboardTeamDataDisplayName = this.getField(teamData, "a");
            this.scoreboardTeamDataPrefix = this.getField(teamData, "b");
            this.scoreboardTeamDataSuffix = this.getField(teamData, "c");
            this.scoreboardTeamDataNametagVisibility = this.getField(teamData, "d");
            this.scoreboardTeamDataCollisionRule = this.getField(teamData, "e");
            this.scoreboardTeamDataColor = this.getField(teamData, "f");
        } else {
            this.scoreboardTeamDataConstructor = null;
            this.scoreboardTeamDataDisplayName = null;
            this.scoreboardTeamDataPrefix = null;
            this.scoreboardTeamDataSuffix = null;
            this.scoreboardTeamDataNametagVisibility = null;
            this.scoreboardTeamDataCollisionRule = null;
            this.scoreboardTeamDataColor = null;
        }
        this.integerHealthDisplay = this.getEnumValue(this.getNMSClass("world.scores.criteria", "IScoreboardCriteria$EnumScoreboardHealthDisplay"), "INTEGER");
        Class<?> scoreboardActionClass = this.getNMSClass("server", current.getScoreboardActionClass());
        this.scoreboardActionChange = this.getEnumValue(scoreboardActionClass, "CHANGE");
        this.scoreboardActionRemove = this.getEnumValue(scoreboardActionClass, "REMOVE");
        Class<?> craftChatMessage = this.getCraftBukkitClass("util.CraftChatMessage");
        this.fromString = craftChatMessage.getMethod("fromString", String.class);
        Class<?> enumChatFormat = this.getNMSClass("", "EnumChatFormat");
        this.chatColorWhite = this.getEnumValue(enumChatFormat, "WHITE");
    }

    public Object fromString(String text) {
        try {
            if (ServerVersion.current().isLegacy()) {
                return text;
            }
            return Array.get(this.fromString.invoke(null, text), 0);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendPacket(Player player, Object packet) {
        try {
            Object entityPlayer = this.getHandle.invoke((Object)player, new Object[0]);
            Object entityConnection = this.playerConnection.get(entityPlayer);
            this.sendPacket.invoke(entityConnection, packet);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void sendPacket(ScoreboardPlayer player, Object packet) {
        if (player != null && player.getPlayer() != null) {
            this.sendPacket(player.getPlayer(), packet);
        }
    }

    private EmptyConstructor getEmptyConstructor(Class<?> clazz) {
        try {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return () -> constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return () -> this.allocateInstance.invoke(this.unsafe, clazz);
        }
    }

    private Field getField(Class<?> clazz, String name) throws NoSuchFieldException, SecurityException {
        if (name == null) {
            return null;
        }
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }

    private Field getFieldOfType(Class<?> clazz, Class<?> type) throws NoSuchFieldException {
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType() != type) continue;
            return field;
        }
        throw new NoSuchFieldException("Class " + clazz.getName() + " does not have a field of type " + type.getName());
    }

    public <T extends Enum<T>> T getEnumValue(Class<?> enumClass, String value) {
        return (T)Enum.valueOf(enumClass.asSubclass(Enum.class), value);
    }

    public Class<?> getNMSClass(String specificPath, String name) throws ClassNotFoundException {
        if (this.versionSpecificNMS) {
            return Class.forName(this.basePath + name);
        }
        if (specificPath.isEmpty()) {
            return Class.forName(this.basePath + name);
        }
        return Class.forName(this.basePath + specificPath + "." + name);
    }

    public Class<?> getCraftBukkitClass(String name) throws ClassNotFoundException {
        return Class.forName("org.bukkit.craftbukkit.".concat(ServerVersion.current().getExactVersion()).concat(".").concat(name));
    }

    private Method findMethod(Class<?> clazz, Class<?> ... parameters) throws NoSuchMethodException {
        for (Method method : clazz.getMethods()) {
            if (!Arrays.equals(method.getParameterTypes(), parameters)) continue;
            return method;
        }
        throw new NoSuchMethodException("Class " + clazz + " does not have a method with parameters " + Arrays.stream(parameters).map(Class::getName).collect(Collectors.joining(", ")));
    }

    public Object getUnsafe() {
        return this.unsafe;
    }

    public Method getAllocateInstance() {
        return this.allocateInstance;
    }

    public Field getPlayerConnection() {
        return this.playerConnection;
    }

    public Method getGetHandle() {
        return this.getHandle;
    }

    public Method getSendPacket() {
        return this.sendPacket;
    }

    public EmptyConstructor getPacketPlayOutScoreboardObjectiveConstructor() {
        return this.packetPlayOutScoreboardObjectiveConstructor;
    }

    public Field getPacketPlayOutScoreboardObjectiveName() {
        return this.packetPlayOutScoreboardObjectiveName;
    }

    public Field getPacketPlayOutScoreboardObjectiveDisplayName() {
        return this.packetPlayOutScoreboardObjectiveDisplayName;
    }

    public Field getPacketPlayOutScoreboardObjectiveHealthDisplay() {
        return this.packetPlayOutScoreboardObjectiveHealthDisplay;
    }

    public Field getPacketPlayOutScoreboardObjectiveMode() {
        return this.packetPlayOutScoreboardObjectiveMode;
    }

    public EmptyConstructor getPacketPlayOutScoreboardDisplayObjectiveConstructor() {
        return this.packetPlayOutScoreboardDisplayObjectiveConstructor;
    }

    public Field getPacketPlayOutScoreboardDisplayObjectivePosition() {
        return this.packetPlayOutScoreboardDisplayObjectivePosition;
    }

    public Field getPacketPlayOutScoreboardDisplayObjectiveName() {
        return this.packetPlayOutScoreboardDisplayObjectiveName;
    }

    public EmptyConstructor getPacketPlayOutScoreboardScoreConstructor() {
        return this.packetPlayOutScoreboardScoreConstructor;
    }

    public Field getPacketPlayOutScoreboardScoreName() {
        return this.packetPlayOutScoreboardScoreName;
    }

    public Field getPacketPlayOutScoreboardScoreObjectiveName() {
        return this.packetPlayOutScoreboardScoreObjectiveName;
    }

    public Field getPacketPlayOutScoreboardScoreValue() {
        return this.packetPlayOutScoreboardScoreValue;
    }

    public Field getPacketPlayOutScoreboardScoreAction() {
        return this.packetPlayOutScoreboardScoreAction;
    }

    public EmptyConstructor getPacketPlayOutScoreboardTeamConstructor() {
        return this.packetPlayOutScoreboardTeamConstructor;
    }

    public Field getPacketPlayOutScoreboardTeamName() {
        return this.packetPlayOutScoreboardTeamName;
    }

    public Field getPacketPlayOutScoreboardTeamDisplayName() {
        return this.packetPlayOutScoreboardTeamDisplayName;
    }

    public Field getPacketPlayOutScoreboardTeamPrefix() {
        return this.packetPlayOutScoreboardTeamPrefix;
    }

    public Field getPacketPlayOutScoreboardTeamSuffix() {
        return this.packetPlayOutScoreboardTeamSuffix;
    }

    public Field getPacketPlayOutScoreboardTeamColor() {
        return this.packetPlayOutScoreboardTeamColor;
    }

    public Field getPacketPlayOutScoreboardTeamNames() {
        return this.packetPlayOutScoreboardTeamNames;
    }

    public Field getPacketPlayOutScoreboardTeamMode() {
        return this.packetPlayOutScoreboardTeamMode;
    }

    public Field getPacketPlayOutScoreboardTeamData() {
        return this.packetPlayOutScoreboardTeamData;
    }

    public EmptyConstructor getScoreboardTeamDataConstructor() {
        return this.scoreboardTeamDataConstructor;
    }

    public Field getScoreboardTeamDataDisplayName() {
        return this.scoreboardTeamDataDisplayName;
    }

    public Field getScoreboardTeamDataPrefix() {
        return this.scoreboardTeamDataPrefix;
    }

    public Field getScoreboardTeamDataSuffix() {
        return this.scoreboardTeamDataSuffix;
    }

    public Field getScoreboardTeamDataNametagVisibility() {
        return this.scoreboardTeamDataNametagVisibility;
    }

    public Field getScoreboardTeamDataCollisionRule() {
        return this.scoreboardTeamDataCollisionRule;
    }

    public Field getScoreboardTeamDataColor() {
        return this.scoreboardTeamDataColor;
    }

    public Object getIntegerHealthDisplay() {
        return this.integerHealthDisplay;
    }

    public Object getScoreboardActionChange() {
        return this.scoreboardActionChange;
    }

    public Object getScoreboardActionRemove() {
        return this.scoreboardActionRemove;
    }

    public Object getChatColorWhite() {
        return this.chatColorWhite;
    }

    public Method getFromString() {
        return this.fromString;
    }

    public boolean isVersionSpecificNMS() {
        return this.versionSpecificNMS;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public static interface EmptyConstructor {
        public Object newInstance() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException;
    }
}

