/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.update;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private static final long SIX_HOUR_IN_TICKS = 432000L;
    private static final int RESOURCE_ID = 20848;
    private static final String SPIGOT_RESOURCE_PAGE = "https://www.spigotmc.org/resources/20848";
    private static final String SPIGOT_API_PAGE = "https://api.spigotmc.org/legacy/update.php?resource=20848";
    private final AnimatedScoreboard plugin;
    private boolean updateAvailable;
    private int versionsBehind;
    private String spigotVersion;

    public UpdateChecker(AnimatedScoreboard plugin) {
        this.plugin = plugin;
    }

    public void init() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            this.plugin.getLogger().info("Checking for an update!");
            String currentVersion = this.plugin.getDescription().getVersion();
            this.spigotVersion = this.getSpigotVersion();
            this.versionsBehind = this.calculate(this.spigotVersion, currentVersion);
            if (this.versionsBehind >= 1) {
                this.updateAvailable = true;
                this.plugin.getLogger().info("You are " + this.versionsBehind + " version" + (this.versionsBehind == 1 ? "" : "s") + " behind! Get AnimatedScoreboard(v" + this.spigotVersion + ") at:");
                this.plugin.getLogger().info(SPIGOT_RESOURCE_PAGE);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    this.notifyPlayer(player);
                }
            } else {
                this.plugin.getLogger().info("No new versions found for the plugin!");
            }
        }, 1L, 432000L);
    }

    private int getVersion(String version) {
        version = version.replace(".", "");
        return Integer.parseInt(version);
    }

    private int calculate(String current, String old) {
        return this.getVersion(current) - this.getVersion(old);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSpigotVersion() {
        try {
            URLConnection connection = new URL(SPIGOT_API_PAGE).openConnection();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String version = reader.readLine();
                if (version.length() > 7) return "0";
                String string = version;
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "0";
    }

    public void notifyPlayer(Player player) {
        if (!this.updateAvailable || !player.hasPermission("animatedscoreboard.admin")) {
            return;
        }
        TextComponent text = new TextComponent("You are " + this.versionsBehind + " version" + (this.versionsBehind == 1 ? "" : "s") + " behind! Click here to get AnimatedScoreboard(v" + this.spigotVersion + ")!");
        text.setColor(ChatColor.GOLD);
        text.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click here to go to the download page!").color(ChatColor.AQUA).create()));
        text.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, SPIGOT_RESOURCE_PAGE));
        player.spigot().sendMessage((BaseComponent)text);
    }
}

