/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.storage;

import com.google.common.collect.Maps;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.storage.PlayerStorage;

public class SQLiteStorage
implements PlayerStorage {
    private String url;

    @Override
    public boolean setup(AnimatedScoreboard plugin) {
        this.url = "jdbc:sqlite:" + new File(plugin.getDataFolder(), "playerdata-sqlite.db");
        try (Connection connection = DriverManager.getConnection(this.url);
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS playerdata (uuid VARCHAR(36) NOT NULL,enabled BOOLEAN NOT NULL DEFAULT '1', PRIMARY KEY (uuid));");
        }
        catch (SQLException e) {
            plugin.log(Level.SEVERE, "Something went wrong when trying to set up the SQLite connection!", new Object[0]);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public CompletableFuture<Boolean> isScoreboardEnabled(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = DriverManager.getConnection(this.url);
                 PreparedStatement statement = connection.prepareStatement("SELECT enabled FROM playerdata WHERE uuid=?;");){
                statement.setString(1, uuid.toString());
                try (ResultSet result = statement.executeQuery();){
                    if (!result.next()) return true;
                    Boolean bl = result.getBoolean("enabled");
                    return bl;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return true;
        });
    }

    @Override
    public void setScoreboardEnabled(UUID uuid, boolean enabled) {
        if (AnimatedScoreboard.getInstance().isDisabling()) {
            this.save(uuid, enabled);
        } else {
            CompletableFuture.runAsync(() -> this.save(uuid, enabled));
        }
    }

    private void save(UUID uuid, boolean enabled) {
        try (Connection connection = DriverManager.getConnection(this.url);
             PreparedStatement insert = connection.prepareStatement("REPLACE INTO playerdata(uuid,enabled) VALUES (?,?);");){
            insert.setString(1, uuid.toString());
            insert.setBoolean(2, enabled);
            insert.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isValid(AnimatedScoreboard plugin) {
        try {
            Class.forName("org.sqlite.JDBC");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean exists(AnimatedScoreboard plugin) {
        return new File(plugin.getDataFolder(), "playerdata-sqlite.db").exists();
    }

    @Override
    public Map<UUID, Boolean> clearAll(AnimatedScoreboard plugin) {
        File file = new File(plugin.getDataFolder(), "playerdata-sqlite.db");
        if (!file.exists()) {
            return Collections.emptyMap();
        }
        String url = "jdbc:sqlite:" + file;
        HashMap data = Maps.newHashMap();
        try (Connection connection = DriverManager.getConnection(url);
             Statement statement = connection.createStatement();
             ResultSet result = statement.executeQuery("SELECT * FROM playerdata");){
            while (result.next()) {
                data.put(UUID.fromString(result.getString("uuid")), result.getBoolean("enabled"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.url = null;
        file.delete();
        return data;
    }

    @Override
    public void importAll(Map<UUID, Boolean> data) {
        try (Connection connection = DriverManager.getConnection(this.url);
             PreparedStatement statement = connection.prepareStatement("REPLACE INTO playerdata VALUES (?,?);");){
            for (Map.Entry<UUID, Boolean> entry : data.entrySet()) {
                statement.setString(1, entry.getKey().toString());
                statement.setBoolean(2, entry.getValue());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

