/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.storage;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.config.PluginConfig;
import me.jasperjh.animatedscoreboard.storage.PlayerStorage;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileStorage
implements PlayerStorage {
    private PluginConfig playerConfig;

    @Override
    public boolean setup(AnimatedScoreboard plugin) {
        this.playerConfig = new PluginConfig(plugin, "playerdata");
        return true;
    }

    @Override
    public CompletableFuture<Boolean> isScoreboardEnabled(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> this.playerConfig.getBoolean("enabled." + uuid, true));
    }

    @Override
    public void setScoreboardEnabled(UUID uuid, boolean enabled) {
        if (AnimatedScoreboard.getInstance().isDisabling()) {
            this.save(uuid, enabled);
        } else {
            CompletableFuture.runAsync(() -> this.save(uuid, enabled));
        }
    }

    private void save(UUID uuid, boolean enabled) {
        this.playerConfig.set("enabled." + uuid, enabled);
    }

    @Override
    public void close() {
        this.playerConfig.saveConfig();
    }

    @Override
    public boolean isValid(AnimatedScoreboard plugin) {
        return true;
    }

    @Override
    public boolean exists(AnimatedScoreboard plugin) {
        return new File(plugin.getDataFolder(), "playerdata.yml").exists();
    }

    @Override
    public Map<UUID, Boolean> clearAll(AnimatedScoreboard plugin) {
        File file = new File(plugin.getDataFolder(), "playerdata.yml");
        if (!file.exists()) {
            return Collections.emptyMap();
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        if (!configuration.contains("enabled") || !configuration.isConfigurationSection("enabled")) {
            file.delete();
            return Collections.emptyMap();
        }
        HashMap data = Maps.newHashMap();
        for (String key : configuration.getConfigurationSection("enabled").getKeys(false)) {
            UUID uuid = UUID.fromString(key);
            data.put(uuid, configuration.getBoolean("enabled." + uuid));
        }
        this.playerConfig = null;
        file.delete();
        return data;
    }

    @Override
    public void importAll(Map<UUID, Boolean> data) {
        for (Map.Entry<UUID, Boolean> entry : data.entrySet()) {
            this.playerConfig.set("enabled." + entry.getKey(), entry.getValue());
        }
        this.playerConfig.saveConfig();
    }
}

