/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.objects.trigger.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.enums.Messages;
import me.jasperjh.animatedscoreboard.objects.trigger.reflection.IReflection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TriggerMethod
implements IReflection {
    private final AnimatedScoreboard plugin;
    private String methodName;
    private Method method;

    @Override
    public void load(Class<?> eventClass, String name) {
        try {
            this.methodName = name;
            for (Method methods : eventClass.getMethods()) {
                if (!methods.getName().equalsIgnoreCase(this.methodName)) continue;
                this.method = methods;
                this.method.setAccessible(true);
                break;
            }
            if (this.method == null) {
                for (Method methods : eventClass.getDeclaredMethods()) {
                    if (!methods.getName().equalsIgnoreCase(this.methodName)) continue;
                    this.method = methods;
                    this.method.setAccessible(true);
                    break;
                }
            }
            if (this.method == null || !this.method.getReturnType().isAssignableFrom(Player.class)) {
                Messages.TRIGGER_REGISTER_METHOD.log(this.plugin, Level.SEVERE, "%class_name%", eventClass.getName());
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object get(Event event) {
        try {
            return this.method.invoke((Object)event, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Messages.TRIGGER_REGISTER_METHOD.log(this.plugin, Level.SEVERE, "%class_name%", event.getClass().getName());
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getWithArguments(Event event, Object ... arguments) {
        return this.get(event);
    }

    public AnimatedScoreboard getPlugin() {
        return this.plugin;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Method getMethod() {
        return this.method;
    }

    public TriggerMethod(AnimatedScoreboard plugin) {
        this.plugin = plugin;
    }
}

